package io.apicurio.datamodels.models.asyncapi.v21;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.asyncapi.AsyncApiParameter;
import io.apicurio.datamodels.models.asyncapi.v21.visitors.AsyncApi21Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsyncApi21ParametersImpl extends NodeImpl implements AsyncApi21Parameters {

	private Map<String, AsyncApiParameter> _items = new LinkedHashMap<>();

	@Override
	public AsyncApiParameter getItem(String name) {
		return this._items.get(name);
	}

	@Override
	public List<AsyncApiParameter> getItems() {
		List<AsyncApiParameter> rval = new ArrayList<>();
		rval.addAll(this._items.values());
		return rval;
	}

	@Override
	public List<String> getItemNames() {
		List<String> rval = new ArrayList<>();
		rval.addAll(this._items.keySet());
		return rval;
	}

	@Override
	public void addItem(String name, AsyncApiParameter item) {
		this._items.put(name, item);
	}

	@Override
	public AsyncApiParameter removeItem(String name) {
		return this._items.remove(name);
	}

	@Override
	public AsyncApi21Parameter createParameter() {
		AsyncApi21ParameterImpl node = new AsyncApi21ParameterImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi21Visitor viz = (AsyncApi21Visitor) visitor;
		viz.visitParameters(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi21ParametersImpl();
	}
}