package io.apicurio.datamodels.models.asyncapi.v22;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.ExternalDocumentation;
import io.apicurio.datamodels.models.Info;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.RootNodeImpl;
import io.apicurio.datamodels.models.Tag;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannels;
import io.apicurio.datamodels.models.asyncapi.AsyncApiComponents;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServers;
import io.apicurio.datamodels.models.asyncapi.v22.visitors.AsyncApi22Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsyncApi22DocumentImpl extends RootNodeImpl implements AsyncApi22Document {

	private String asyncapi;
	private String id;
	private Info info;
	private AsyncApiServers servers;
	private String defaultContentType;
	private AsyncApiChannels channels;
	private AsyncApiComponents components;
	private List<Tag> tags;
	private ExternalDocumentation externalDocs;
	private Map<String, JsonNode> extensions;

	public AsyncApi22DocumentImpl() {
		super(ModelType.ASYNCAPI22);
	}

	@Override
	public String getAsyncapi() {
		return asyncapi;
	}

	@Override
	public void setAsyncapi(String value) {
		this.asyncapi = value;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public void setId(String value) {
		this.id = value;
	}

	@Override
	public Info getInfo() {
		return info;
	}

	@Override
	public void setInfo(Info value) {
		this.info = value;
	}

	@Override
	public AsyncApi22Info createInfo() {
		AsyncApi22InfoImpl node = new AsyncApi22InfoImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public AsyncApiServers getServers() {
		return servers;
	}

	@Override
	public void setServers(AsyncApiServers value) {
		this.servers = value;
	}

	@Override
	public AsyncApi22Servers createServers() {
		AsyncApi22ServersImpl node = new AsyncApi22ServersImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public String getDefaultContentType() {
		return defaultContentType;
	}

	@Override
	public void setDefaultContentType(String value) {
		this.defaultContentType = value;
	}

	@Override
	public AsyncApiChannels getChannels() {
		return channels;
	}

	@Override
	public void setChannels(AsyncApiChannels value) {
		this.channels = value;
	}

	@Override
	public AsyncApi22Channels createChannels() {
		AsyncApi22ChannelsImpl node = new AsyncApi22ChannelsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public AsyncApiComponents getComponents() {
		return components;
	}

	@Override
	public void setComponents(AsyncApiComponents value) {
		this.components = value;
	}

	@Override
	public AsyncApi22Components createComponents() {
		AsyncApi22ComponentsImpl node = new AsyncApi22ComponentsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public AsyncApi22Tag createTag() {
		AsyncApi22TagImpl node = new AsyncApi22TagImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public List<Tag> getTags() {
		return tags;
	}

	@Override
	public void addTag(Tag value) {
		if (this.tags == null) {
			this.tags = new ArrayList<>();
		}
		this.tags.add(value);
	}

	@Override
	public void clearTags() {
		if (this.tags != null) {
			this.tags.clear();
		}
	}

	@Override
	public void removeTag(Tag value) {
		if (this.tags != null) {
			this.tags.remove(value);
		}
	}

	@Override
	public ExternalDocumentation getExternalDocs() {
		return externalDocs;
	}

	@Override
	public void setExternalDocs(ExternalDocumentation value) {
		this.externalDocs = value;
	}

	@Override
	public AsyncApi22ExternalDocumentation createExternalDocumentation() {
		AsyncApi22ExternalDocumentationImpl node = new AsyncApi22ExternalDocumentationImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi22Visitor viz = (AsyncApi22Visitor) visitor;
		viz.visitDocument(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi22DocumentImpl();
	}
}