package io.apicurio.datamodels.models.asyncapi.v22;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.OAuthFlow;
import io.apicurio.datamodels.models.asyncapi.v22.visitors.AsyncApi22Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class AsyncApi22OAuthFlowsImpl extends NodeImpl implements AsyncApi22OAuthFlows {

	private OAuthFlow implicit;
	private OAuthFlow password;
	private OAuthFlow clientCredentials;
	private OAuthFlow authorizationCode;
	private Map<String, JsonNode> extensions;

	@Override
	public OAuthFlow getImplicit() {
		return implicit;
	}

	@Override
	public void setImplicit(OAuthFlow value) {
		this.implicit = value;
	}

	@Override
	public AsyncApi22OAuthFlow createOAuthFlow() {
		AsyncApi22OAuthFlowImpl node = new AsyncApi22OAuthFlowImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public OAuthFlow getPassword() {
		return password;
	}

	@Override
	public void setPassword(OAuthFlow value) {
		this.password = value;
	}

	@Override
	public OAuthFlow getClientCredentials() {
		return clientCredentials;
	}

	@Override
	public void setClientCredentials(OAuthFlow value) {
		this.clientCredentials = value;
	}

	@Override
	public OAuthFlow getAuthorizationCode() {
		return authorizationCode;
	}

	@Override
	public void setAuthorizationCode(OAuthFlow value) {
		this.authorizationCode = value;
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi22Visitor viz = (AsyncApi22Visitor) visitor;
		viz.visitOAuthFlows(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi22OAuthFlowsImpl();
	}
}