package io.apicurio.datamodels.models.asyncapi.v22;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServer;
import io.apicurio.datamodels.models.asyncapi.v22.visitors.AsyncApi22Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsyncApi22ServersImpl extends NodeImpl implements AsyncApi22Servers {

	private Map<String, AsyncApiServer> _items = new LinkedHashMap<>();

	@Override
	public AsyncApiServer getItem(String name) {
		return this._items.get(name);
	}

	@Override
	public List<AsyncApiServer> getItems() {
		List<AsyncApiServer> rval = new ArrayList<>();
		rval.addAll(this._items.values());
		return rval;
	}

	@Override
	public List<String> getItemNames() {
		List<String> rval = new ArrayList<>();
		rval.addAll(this._items.keySet());
		return rval;
	}

	@Override
	public void addItem(String name, AsyncApiServer item) {
		this._items.put(name, item);
	}

	@Override
	public AsyncApiServer removeItem(String name) {
		return this._items.remove(name);
	}

	@Override
	public AsyncApi22Server createServer() {
		AsyncApi22ServerImpl node = new AsyncApi22ServerImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi22Visitor viz = (AsyncApi22Visitor) visitor;
		viz.visitServers(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi22ServersImpl();
	}
}