package io.apicurio.datamodels.models.asyncapi.v23;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.asyncapi.v23.visitors.AsyncApi23Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsyncApi23BindingImpl extends NodeImpl implements AsyncApi23Binding {

	private Map<String, JsonNode> _items = new LinkedHashMap<>();
	private Map<String, JsonNode> extensions;

	@Override
	public JsonNode getItem(String name) {
		return this._items.get(name);
	}

	@Override
	public List<JsonNode> getItems() {
		List<JsonNode> rval = new ArrayList<>();
		rval.addAll(this._items.values());
		return rval;
	}

	@Override
	public List<String> getItemNames() {
		List<String> rval = new ArrayList<>();
		rval.addAll(this._items.keySet());
		return rval;
	}

	@Override
	public void addItem(String name, JsonNode item) {
		this._items.put(name, item);
	}

	@Override
	public JsonNode removeItem(String name) {
		return this._items.remove(name);
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi23Visitor viz = (AsyncApi23Visitor) visitor;
		viz.visitBinding(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi23BindingImpl();
	}
}