package io.apicurio.datamodels.models.asyncapi.v23;

import io.apicurio.datamodels.models.asyncapi.AsyncApiComponents;
import java.util.Map;

public interface AsyncApi23Components extends AsyncApiComponents, AsyncApi23Extensible {

	public AsyncApi23Server createServer();

	public Map<String, AsyncApi23Server> getServers();

	public void addServer(String name, AsyncApi23Server value);

	public void clearServers();

	public void removeServer(String name);

	public AsyncApi23ChannelItem createChannelItem();

	public Map<String, AsyncApi23ChannelItem> getChannels();

	public void addChannel(String name, AsyncApi23ChannelItem value);

	public void clearChannels();

	public void removeChannel(String name);
}