package io.apicurio.datamodels.models.asyncapi.v24;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem;
import io.apicurio.datamodels.models.asyncapi.v24.visitors.AsyncApi24Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsyncApi24ChannelsImpl extends NodeImpl implements AsyncApi24Channels {

	private Map<String, AsyncApiChannelItem> _items = new LinkedHashMap<>();

	@Override
	public AsyncApiChannelItem getItem(String name) {
		return this._items.get(name);
	}

	@Override
	public List<AsyncApiChannelItem> getItems() {
		List<AsyncApiChannelItem> rval = new ArrayList<>();
		rval.addAll(this._items.values());
		return rval;
	}

	@Override
	public List<String> getItemNames() {
		List<String> rval = new ArrayList<>();
		rval.addAll(this._items.keySet());
		return rval;
	}

	@Override
	public void addItem(String name, AsyncApiChannelItem item) {
		this._items.put(name, item);
	}

	@Override
	public AsyncApiChannelItem removeItem(String name) {
		return this._items.remove(name);
	}

	@Override
	public AsyncApi24ChannelItem createChannelItem() {
		AsyncApi24ChannelItemImpl node = new AsyncApi24ChannelItemImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi24Visitor viz = (AsyncApi24Visitor) visitor;
		viz.visitChannels(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi24ChannelsImpl();
	}
}