package io.apicurio.datamodels.models.asyncapi.v24;

import io.apicurio.datamodels.models.asyncapi.AsyncApiComponents;
import java.util.Map;

public interface AsyncApi24Components extends AsyncApiComponents, AsyncApi24Extensible {

	public AsyncApi24Server createServer();

	public Map<String, AsyncApi24Server> getServers();

	public void addServer(String name, AsyncApi24Server value);

	public void clearServers();

	public void removeServer(String name);

	public AsyncApi24ServerVariable createServerVariable();

	public Map<String, AsyncApi24ServerVariable> getServerVariables();

	public void addServerVariable(String name, AsyncApi24ServerVariable value);

	public void clearServerVariables();

	public void removeServerVariable(String name);

	public AsyncApi24ChannelItem createChannelItem();

	public Map<String, AsyncApi24ChannelItem> getChannels();

	public void addChannel(String name, AsyncApi24ChannelItem value);

	public void clearChannels();

	public void removeChannel(String name);
}