package io.apicurio.datamodels.models.asyncapi.v25;

import io.apicurio.datamodels.models.asyncapi.AsyncApiComponents;
import java.util.Map;

public interface AsyncApi25Components extends AsyncApiComponents, AsyncApi25Extensible {

	public AsyncApi25Server createServer();

	public Map<String, AsyncApi25Server> getServers();

	public void addServer(String name, AsyncApi25Server value);

	public void clearServers();

	public void removeServer(String name);

	public AsyncApi25ServerVariable createServerVariable();

	public Map<String, AsyncApi25ServerVariable> getServerVariables();

	public void addServerVariable(String name, AsyncApi25ServerVariable value);

	public void clearServerVariables();

	public void removeServerVariable(String name);

	public AsyncApi25ChannelItem createChannelItem();

	public Map<String, AsyncApi25ChannelItem> getChannels();

	public void addChannel(String name, AsyncApi25ChannelItem value);

	public void clearChannels();

	public void removeChannel(String name);
}