package io.apicurio.datamodels.models.asyncapi.v25;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiCorrelationID;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessageBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessageTrait;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOperationBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOperationTrait;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServerBindings;
import io.apicurio.datamodels.models.asyncapi.v25.visitors.AsyncApi25Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class AsyncApi25ComponentsImpl extends NodeImpl implements AsyncApi25Components {

	private Map<String, Schema> schemas;
	private Map<String, AsyncApi25Server> servers;
	private Map<String, AsyncApi25ServerVariable> serverVariables;
	private Map<String, AsyncApi25ChannelItem> channels;
	private Map<String, AsyncApiMessage> messages;
	private Map<String, SecurityScheme> securitySchemes;
	private Map<String, Parameter> parameters;
	private Map<String, AsyncApiCorrelationID> correlationIds;
	private Map<String, AsyncApiOperationTrait> operationTraits;
	private Map<String, AsyncApiMessageTrait> messageTraits;
	private Map<String, AsyncApiServerBindings> serverBindings;
	private Map<String, AsyncApiChannelBindings> channelBindings;
	private Map<String, AsyncApiOperationBindings> operationBindings;
	private Map<String, AsyncApiMessageBindings> messageBindings;
	private Map<String, JsonNode> extensions;

	@Override
	public AsyncApi25Schema createSchema() {
		AsyncApi25SchemaImpl node = new AsyncApi25SchemaImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, Schema> getSchemas() {
		return schemas;
	}

	@Override
	public void addSchema(String name, Schema value) {
		if (this.schemas == null) {
			this.schemas = new LinkedHashMap<>();
		}
		this.schemas.put(name, value);
	}

	@Override
	public void clearSchemas() {
		if (this.schemas != null) {
			this.schemas.clear();
		}
	}

	@Override
	public void removeSchema(String name) {
		if (this.schemas != null) {
			this.schemas.remove(name);
		}
	}

	@Override
	public AsyncApi25Server createServer() {
		AsyncApi25ServerImpl node = new AsyncApi25ServerImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApi25Server> getServers() {
		return servers;
	}

	@Override
	public void addServer(String name, AsyncApi25Server value) {
		if (this.servers == null) {
			this.servers = new LinkedHashMap<>();
		}
		this.servers.put(name, value);
	}

	@Override
	public void clearServers() {
		if (this.servers != null) {
			this.servers.clear();
		}
	}

	@Override
	public void removeServer(String name) {
		if (this.servers != null) {
			this.servers.remove(name);
		}
	}

	@Override
	public AsyncApi25ServerVariable createServerVariable() {
		AsyncApi25ServerVariableImpl node = new AsyncApi25ServerVariableImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApi25ServerVariable> getServerVariables() {
		return serverVariables;
	}

	@Override
	public void addServerVariable(String name, AsyncApi25ServerVariable value) {
		if (this.serverVariables == null) {
			this.serverVariables = new LinkedHashMap<>();
		}
		this.serverVariables.put(name, value);
	}

	@Override
	public void clearServerVariables() {
		if (this.serverVariables != null) {
			this.serverVariables.clear();
		}
	}

	@Override
	public void removeServerVariable(String name) {
		if (this.serverVariables != null) {
			this.serverVariables.remove(name);
		}
	}

	@Override
	public AsyncApi25ChannelItem createChannelItem() {
		AsyncApi25ChannelItemImpl node = new AsyncApi25ChannelItemImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApi25ChannelItem> getChannels() {
		return channels;
	}

	@Override
	public void addChannel(String name, AsyncApi25ChannelItem value) {
		if (this.channels == null) {
			this.channels = new LinkedHashMap<>();
		}
		this.channels.put(name, value);
	}

	@Override
	public void clearChannels() {
		if (this.channels != null) {
			this.channels.clear();
		}
	}

	@Override
	public void removeChannel(String name) {
		if (this.channels != null) {
			this.channels.remove(name);
		}
	}

	@Override
	public AsyncApi25Message createMessage() {
		AsyncApi25MessageImpl node = new AsyncApi25MessageImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApiMessage> getMessages() {
		return messages;
	}

	@Override
	public void addMessage(String name, AsyncApiMessage value) {
		if (this.messages == null) {
			this.messages = new LinkedHashMap<>();
		}
		this.messages.put(name, value);
	}

	@Override
	public void clearMessages() {
		if (this.messages != null) {
			this.messages.clear();
		}
	}

	@Override
	public void removeMessage(String name) {
		if (this.messages != null) {
			this.messages.remove(name);
		}
	}

	@Override
	public AsyncApi25SecurityScheme createSecurityScheme() {
		AsyncApi25SecuritySchemeImpl node = new AsyncApi25SecuritySchemeImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, SecurityScheme> getSecuritySchemes() {
		return securitySchemes;
	}

	@Override
	public void addSecurityScheme(String name, SecurityScheme value) {
		if (this.securitySchemes == null) {
			this.securitySchemes = new LinkedHashMap<>();
		}
		this.securitySchemes.put(name, value);
	}

	@Override
	public void clearSecuritySchemes() {
		if (this.securitySchemes != null) {
			this.securitySchemes.clear();
		}
	}

	@Override
	public void removeSecurityScheme(String name) {
		if (this.securitySchemes != null) {
			this.securitySchemes.remove(name);
		}
	}

	@Override
	public AsyncApi25Parameter createParameter() {
		AsyncApi25ParameterImpl node = new AsyncApi25ParameterImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, Parameter> getParameters() {
		return parameters;
	}

	@Override
	public void addParameter(String name, Parameter value) {
		if (this.parameters == null) {
			this.parameters = new LinkedHashMap<>();
		}
		this.parameters.put(name, value);
	}

	@Override
	public void clearParameters() {
		if (this.parameters != null) {
			this.parameters.clear();
		}
	}

	@Override
	public void removeParameter(String name) {
		if (this.parameters != null) {
			this.parameters.remove(name);
		}
	}

	@Override
	public AsyncApi25CorrelationID createCorrelationID() {
		AsyncApi25CorrelationIDImpl node = new AsyncApi25CorrelationIDImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApiCorrelationID> getCorrelationIds() {
		return correlationIds;
	}

	@Override
	public void addCorrelationId(String name, AsyncApiCorrelationID value) {
		if (this.correlationIds == null) {
			this.correlationIds = new LinkedHashMap<>();
		}
		this.correlationIds.put(name, value);
	}

	@Override
	public void clearCorrelationIds() {
		if (this.correlationIds != null) {
			this.correlationIds.clear();
		}
	}

	@Override
	public void removeCorrelationId(String name) {
		if (this.correlationIds != null) {
			this.correlationIds.remove(name);
		}
	}

	@Override
	public AsyncApi25OperationTrait createOperationTrait() {
		AsyncApi25OperationTraitImpl node = new AsyncApi25OperationTraitImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApiOperationTrait> getOperationTraits() {
		return operationTraits;
	}

	@Override
	public void addOperationTrait(String name, AsyncApiOperationTrait value) {
		if (this.operationTraits == null) {
			this.operationTraits = new LinkedHashMap<>();
		}
		this.operationTraits.put(name, value);
	}

	@Override
	public void clearOperationTraits() {
		if (this.operationTraits != null) {
			this.operationTraits.clear();
		}
	}

	@Override
	public void removeOperationTrait(String name) {
		if (this.operationTraits != null) {
			this.operationTraits.remove(name);
		}
	}

	@Override
	public AsyncApi25MessageTrait createMessageTrait() {
		AsyncApi25MessageTraitImpl node = new AsyncApi25MessageTraitImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApiMessageTrait> getMessageTraits() {
		return messageTraits;
	}

	@Override
	public void addMessageTrait(String name, AsyncApiMessageTrait value) {
		if (this.messageTraits == null) {
			this.messageTraits = new LinkedHashMap<>();
		}
		this.messageTraits.put(name, value);
	}

	@Override
	public void clearMessageTraits() {
		if (this.messageTraits != null) {
			this.messageTraits.clear();
		}
	}

	@Override
	public void removeMessageTrait(String name) {
		if (this.messageTraits != null) {
			this.messageTraits.remove(name);
		}
	}

	@Override
	public AsyncApi25ServerBindings createServerBindings() {
		AsyncApi25ServerBindingsImpl node = new AsyncApi25ServerBindingsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApiServerBindings> getServerBindings() {
		return serverBindings;
	}

	@Override
	public void addServerBinding(String name, AsyncApiServerBindings value) {
		if (this.serverBindings == null) {
			this.serverBindings = new LinkedHashMap<>();
		}
		this.serverBindings.put(name, value);
	}

	@Override
	public void clearServerBindings() {
		if (this.serverBindings != null) {
			this.serverBindings.clear();
		}
	}

	@Override
	public void removeServerBinding(String name) {
		if (this.serverBindings != null) {
			this.serverBindings.remove(name);
		}
	}

	@Override
	public AsyncApi25ChannelBindings createChannelBindings() {
		AsyncApi25ChannelBindingsImpl node = new AsyncApi25ChannelBindingsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApiChannelBindings> getChannelBindings() {
		return channelBindings;
	}

	@Override
	public void addChannelBinding(String name, AsyncApiChannelBindings value) {
		if (this.channelBindings == null) {
			this.channelBindings = new LinkedHashMap<>();
		}
		this.channelBindings.put(name, value);
	}

	@Override
	public void clearChannelBindings() {
		if (this.channelBindings != null) {
			this.channelBindings.clear();
		}
	}

	@Override
	public void removeChannelBinding(String name) {
		if (this.channelBindings != null) {
			this.channelBindings.remove(name);
		}
	}

	@Override
	public AsyncApi25OperationBindings createOperationBindings() {
		AsyncApi25OperationBindingsImpl node = new AsyncApi25OperationBindingsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApiOperationBindings> getOperationBindings() {
		return operationBindings;
	}

	@Override
	public void addOperationBinding(String name, AsyncApiOperationBindings value) {
		if (this.operationBindings == null) {
			this.operationBindings = new LinkedHashMap<>();
		}
		this.operationBindings.put(name, value);
	}

	@Override
	public void clearOperationBindings() {
		if (this.operationBindings != null) {
			this.operationBindings.clear();
		}
	}

	@Override
	public void removeOperationBinding(String name) {
		if (this.operationBindings != null) {
			this.operationBindings.remove(name);
		}
	}

	@Override
	public AsyncApi25MessageBindings createMessageBindings() {
		AsyncApi25MessageBindingsImpl node = new AsyncApi25MessageBindingsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, AsyncApiMessageBindings> getMessageBindings() {
		return messageBindings;
	}

	@Override
	public void addMessageBinding(String name, AsyncApiMessageBindings value) {
		if (this.messageBindings == null) {
			this.messageBindings = new LinkedHashMap<>();
		}
		this.messageBindings.put(name, value);
	}

	@Override
	public void clearMessageBindings() {
		if (this.messageBindings != null) {
			this.messageBindings.clear();
		}
	}

	@Override
	public void removeMessageBinding(String name) {
		if (this.messageBindings != null) {
			this.messageBindings.remove(name);
		}
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi25Visitor viz = (AsyncApi25Visitor) visitor;
		viz.visitComponents(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi25ComponentsImpl();
	}
}