package io.apicurio.datamodels.models.asyncapi.v25;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.asyncapi.AsyncApiCorrelationID;
import io.apicurio.datamodels.models.asyncapi.AsyncApiExternalDocumentation;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessageBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiTag;
import io.apicurio.datamodels.models.asyncapi.v25.visitors.AsyncApi25Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsyncApi25MessageTraitImpl extends NodeImpl implements AsyncApi25MessageTrait {

	private String $ref;
	private String messageId;
	private AsyncApiSchema headers;
	private AsyncApiCorrelationID correlationId;
	private String schemaFormat;
	private String contentType;
	private String name;
	private String title;
	private String summary;
	private String description;
	private List<AsyncApiTag> tags;
	private AsyncApiExternalDocumentation externalDocs;
	private AsyncApiMessageBindings bindings;
	private Map<String, JsonNode> examples;
	private Map<String, JsonNode> extensions;

	@Override
	public String get$ref() {
		return $ref;
	}

	@Override
	public void set$ref(String value) {
		this.$ref = value;
	}

	@Override
	public String getMessageId() {
		return messageId;
	}

	@Override
	public void setMessageId(String value) {
		this.messageId = value;
	}

	@Override
	public AsyncApiSchema getHeaders() {
		return headers;
	}

	@Override
	public void setHeaders(AsyncApiSchema value) {
		this.headers = value;
	}

	@Override
	public AsyncApi25Schema createSchema() {
		AsyncApi25SchemaImpl node = new AsyncApi25SchemaImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public AsyncApiCorrelationID getCorrelationId() {
		return correlationId;
	}

	@Override
	public void setCorrelationId(AsyncApiCorrelationID value) {
		this.correlationId = value;
	}

	@Override
	public AsyncApi25CorrelationID createCorrelationID() {
		AsyncApi25CorrelationIDImpl node = new AsyncApi25CorrelationIDImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public String getSchemaFormat() {
		return schemaFormat;
	}

	@Override
	public void setSchemaFormat(String value) {
		this.schemaFormat = value;
	}

	@Override
	public String getContentType() {
		return contentType;
	}

	@Override
	public void setContentType(String value) {
		this.contentType = value;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public void setName(String value) {
		this.name = value;
	}

	@Override
	public String getTitle() {
		return title;
	}

	@Override
	public void setTitle(String value) {
		this.title = value;
	}

	@Override
	public String getSummary() {
		return summary;
	}

	@Override
	public void setSummary(String value) {
		this.summary = value;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public void setDescription(String value) {
		this.description = value;
	}

	@Override
	public AsyncApi25Tag createTag() {
		AsyncApi25TagImpl node = new AsyncApi25TagImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public List<AsyncApiTag> getTags() {
		return tags;
	}

	@Override
	public void addTag(AsyncApiTag value) {
		if (this.tags == null) {
			this.tags = new ArrayList<>();
		}
		this.tags.add(value);
	}

	@Override
	public void clearTags() {
		if (this.tags != null) {
			this.tags.clear();
		}
	}

	@Override
	public void removeTag(AsyncApiTag value) {
		if (this.tags != null) {
			this.tags.remove(value);
		}
	}

	@Override
	public AsyncApiExternalDocumentation getExternalDocs() {
		return externalDocs;
	}

	@Override
	public void setExternalDocs(AsyncApiExternalDocumentation value) {
		this.externalDocs = value;
	}

	@Override
	public AsyncApi25ExternalDocumentation createExternalDocumentation() {
		AsyncApi25ExternalDocumentationImpl node = new AsyncApi25ExternalDocumentationImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public AsyncApiMessageBindings getBindings() {
		return bindings;
	}

	@Override
	public void setBindings(AsyncApiMessageBindings value) {
		this.bindings = value;
	}

	@Override
	public AsyncApi25MessageBindings createMessageBindings() {
		AsyncApi25MessageBindingsImpl node = new AsyncApi25MessageBindingsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, JsonNode> getExamples() {
		return examples;
	}

	@Override
	public void setExamples(Map<String, JsonNode> value) {
		this.examples = value;
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi25Visitor viz = (AsyncApi25Visitor) visitor;
		viz.visitMessageTrait(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi25MessageTraitImpl();
	}
}