package io.apicurio.datamodels.models.asyncapi.v26;

import io.apicurio.datamodels.models.asyncapi.AsyncApiComponents;
import java.util.Map;

public interface AsyncApi26Components extends AsyncApiComponents, AsyncApi26Extensible {

	public AsyncApi26Server createServer();

	public Map<String, AsyncApi26Server> getServers();

	public void addServer(String name, AsyncApi26Server value);

	public void clearServers();

	public void removeServer(String name);

	public AsyncApi26ServerVariable createServerVariable();

	public Map<String, AsyncApi26ServerVariable> getServerVariables();

	public void addServerVariable(String name, AsyncApi26ServerVariable value);

	public void clearServerVariables();

	public void removeServerVariable(String name);

	public AsyncApi26ChannelItem createChannelItem();

	public Map<String, AsyncApi26ChannelItem> getChannels();

	public void addChannel(String name, AsyncApi26ChannelItem value);

	public void clearChannels();

	public void removeChannel(String name);
}