package io.apicurio.datamodels.models.asyncapi.visitors;

import io.apicurio.datamodels.models.Components;
import io.apicurio.datamodels.models.OAuthFlow;
import io.apicurio.datamodels.models.OAuthFlows;
import io.apicurio.datamodels.models.Server;
import io.apicurio.datamodels.models.ServerVariable;
import io.apicurio.datamodels.models.asyncapi.AsyncApiBinding;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannels;
import io.apicurio.datamodels.models.asyncapi.AsyncApiCorrelationID;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessageBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessageTrait;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOneOfMessages;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOperationBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOperationTrait;
import io.apicurio.datamodels.models.asyncapi.AsyncApiParameters;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServerBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServers;
import io.apicurio.datamodels.models.visitors.Visitor;

public interface AsyncApiVisitor extends Visitor {

	public void visitMessageBindings(AsyncApiMessageBindings node);

	public void visitOAuthFlow(OAuthFlow node);

	public void visitOperationBindings(AsyncApiOperationBindings node);

	public void visitComponents(Components node);

	public void visitChannelBindings(AsyncApiChannelBindings node);

	public void visitParameters(AsyncApiParameters node);

	public void visitServerVariable(ServerVariable node);

	public void visitChannelItem(AsyncApiChannelItem node);

	public void visitMessage(AsyncApiMessage node);

	public void visitOperationTrait(AsyncApiOperationTrait node);

	public void visitServer(Server node);

	public void visitOAuthFlows(OAuthFlows node);

	public void visitServerBindings(AsyncApiServerBindings node);

	public void visitCorrelationID(AsyncApiCorrelationID node);

	public void visitServers(AsyncApiServers node);

	public void visitChannels(AsyncApiChannels node);

	public void visitMessageTrait(AsyncApiMessageTrait node);

	public void visitBinding(AsyncApiBinding node);

	public void visitOneOfMessages(AsyncApiOneOfMessages node);
}