package io.apicurio.datamodels.models.openapi;

import io.apicurio.datamodels.models.Components;
import java.util.Map;

public interface OpenApiComponents extends Components {

	public OpenApiRequestBody createRequestBody();

	public Map<String, OpenApiRequestBody> getRequestBodies();

	public void addRequestBody(String name, OpenApiRequestBody value);

	public void clearRequestBodies();

	public void removeRequestBody(String name);

	public OpenApiExample createExample();

	public Map<String, OpenApiExample> getExamples();

	public void addExample(String name, OpenApiExample value);

	public void clearExamples();

	public void removeExample(String name);

	public OpenApiCallback createCallback();

	public Map<String, OpenApiCallback> getCallbacks();

	public void addCallback(String name, OpenApiCallback value);

	public void clearCallbacks();

	public void removeCallback(String name);

	public OpenApiLink createLink();

	public Map<String, OpenApiLink> getLinks();

	public void addLink(String name, OpenApiLink value);

	public void clearLinks();

	public void removeLink(String name);

	public OpenApiResponse createResponse();

	public Map<String, OpenApiResponse> getResponses();

	public void addResponse(String name, OpenApiResponse value);

	public void clearResponses();

	public void removeResponse(String name);

	public OpenApiHeader createHeader();

	public Map<String, OpenApiHeader> getHeaders();

	public void addHeader(String name, OpenApiHeader value);

	public void clearHeaders();

	public void removeHeader(String name);
}