package io.apicurio.datamodels.models.openapi.v20;

import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import java.util.List;

public interface OpenApi20Document extends RootNode, OpenApiDocument, OpenApi20Extensible {

	public String getSwagger();

	public void setSwagger(String value);

	public String getHost();

	public void setHost(String value);

	public String getBasePath();

	public void setBasePath(String value);

	public List<String> getSchemes();

	public void setSchemes(List<String> value);

	public List<String> getConsumes();

	public void setConsumes(List<String> value);

	public List<String> getProduces();

	public void setProduces(List<String> value);

	public OpenApi20Definitions getDefinitions();

	public void setDefinitions(OpenApi20Definitions value);

	public OpenApi20Definitions createDefinitions();

	public OpenApi20ParameterDefinitions getParameters();

	public void setParameters(OpenApi20ParameterDefinitions value);

	public OpenApi20ParameterDefinitions createParameterDefinitions();

	public OpenApi20ResponseDefinitions getResponses();

	public void setResponses(OpenApi20ResponseDefinitions value);

	public OpenApi20ResponseDefinitions createResponseDefinitions();

	public OpenApi20SecurityDefinitions getSecurityDefinitions();

	public void setSecurityDefinitions(OpenApi20SecurityDefinitions value);

	public OpenApi20SecurityDefinitions createSecurityDefinitions();
}