package io.apicurio.datamodels.models.openapi.v20.visitors;

import io.apicurio.datamodels.models.openapi.v20.OpenApi20Definitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Headers;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Items;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20ParameterDefinitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20ResponseDefinitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Scopes;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityDefinitions;
import io.apicurio.datamodels.models.openapi.visitors.OpenApiVisitor;

public interface OpenApi20Visitor extends OpenApiVisitor {

	public void visitScopes(OpenApi20Scopes node);

	public void visitResponseDefinitions(OpenApi20ResponseDefinitions node);

	public void visitSecurityDefinitions(OpenApi20SecurityDefinitions node);

	public void visitParameterDefinitions(OpenApi20ParameterDefinitions node);

	public void visitDefinitions(OpenApi20Definitions node);

	public void visitHeaders(OpenApi20Headers node);

	public void visitItems(OpenApi20Items node);
}