package io.apicurio.datamodels.models.openapi.v30;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.models.openapi.OpenApiCallback;
import io.apicurio.datamodels.models.openapi.OpenApiExample;
import io.apicurio.datamodels.models.openapi.OpenApiHeader;
import io.apicurio.datamodels.models.openapi.OpenApiLink;
import io.apicurio.datamodels.models.openapi.OpenApiRequestBody;
import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import io.apicurio.datamodels.models.openapi.v30.visitors.OpenApi30Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class OpenApi30ComponentsImpl extends NodeImpl implements OpenApi30Components {

	private Map<String, Schema> schemas;
	private Map<String, OpenApiResponse> responses;
	private Map<String, Parameter> parameters;
	private Map<String, OpenApiExample> examples;
	private Map<String, OpenApiRequestBody> requestBodies;
	private Map<String, OpenApiHeader> headers;
	private Map<String, SecurityScheme> securitySchemes;
	private Map<String, OpenApiLink> links;
	private Map<String, OpenApiCallback> callbacks;
	private Map<String, JsonNode> extensions;

	@Override
	public OpenApi30Schema createSchema() {
		OpenApi30SchemaImpl node = new OpenApi30SchemaImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, Schema> getSchemas() {
		return schemas;
	}

	@Override
	public void addSchema(String name, Schema value) {
		if (this.schemas == null) {
			this.schemas = new LinkedHashMap<>();
		}
		this.schemas.put(name, value);
	}

	@Override
	public void clearSchemas() {
		if (this.schemas != null) {
			this.schemas.clear();
		}
	}

	@Override
	public void removeSchema(String name) {
		if (this.schemas != null) {
			this.schemas.remove(name);
		}
	}

	@Override
	public OpenApi30Response createResponse() {
		OpenApi30ResponseImpl node = new OpenApi30ResponseImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApiResponse> getResponses() {
		return responses;
	}

	@Override
	public void addResponse(String name, OpenApiResponse value) {
		if (this.responses == null) {
			this.responses = new LinkedHashMap<>();
		}
		this.responses.put(name, value);
	}

	@Override
	public void clearResponses() {
		if (this.responses != null) {
			this.responses.clear();
		}
	}

	@Override
	public void removeResponse(String name) {
		if (this.responses != null) {
			this.responses.remove(name);
		}
	}

	@Override
	public OpenApi30Parameter createParameter() {
		OpenApi30ParameterImpl node = new OpenApi30ParameterImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, Parameter> getParameters() {
		return parameters;
	}

	@Override
	public void addParameter(String name, Parameter value) {
		if (this.parameters == null) {
			this.parameters = new LinkedHashMap<>();
		}
		this.parameters.put(name, value);
	}

	@Override
	public void clearParameters() {
		if (this.parameters != null) {
			this.parameters.clear();
		}
	}

	@Override
	public void removeParameter(String name) {
		if (this.parameters != null) {
			this.parameters.remove(name);
		}
	}

	@Override
	public OpenApi30Example createExample() {
		OpenApi30ExampleImpl node = new OpenApi30ExampleImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApiExample> getExamples() {
		return examples;
	}

	@Override
	public void addExample(String name, OpenApiExample value) {
		if (this.examples == null) {
			this.examples = new LinkedHashMap<>();
		}
		this.examples.put(name, value);
	}

	@Override
	public void clearExamples() {
		if (this.examples != null) {
			this.examples.clear();
		}
	}

	@Override
	public void removeExample(String name) {
		if (this.examples != null) {
			this.examples.remove(name);
		}
	}

	@Override
	public OpenApi30RequestBody createRequestBody() {
		OpenApi30RequestBodyImpl node = new OpenApi30RequestBodyImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApiRequestBody> getRequestBodies() {
		return requestBodies;
	}

	@Override
	public void addRequestBody(String name, OpenApiRequestBody value) {
		if (this.requestBodies == null) {
			this.requestBodies = new LinkedHashMap<>();
		}
		this.requestBodies.put(name, value);
	}

	@Override
	public void clearRequestBodies() {
		if (this.requestBodies != null) {
			this.requestBodies.clear();
		}
	}

	@Override
	public void removeRequestBody(String name) {
		if (this.requestBodies != null) {
			this.requestBodies.remove(name);
		}
	}

	@Override
	public OpenApi30Header createHeader() {
		OpenApi30HeaderImpl node = new OpenApi30HeaderImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApiHeader> getHeaders() {
		return headers;
	}

	@Override
	public void addHeader(String name, OpenApiHeader value) {
		if (this.headers == null) {
			this.headers = new LinkedHashMap<>();
		}
		this.headers.put(name, value);
	}

	@Override
	public void clearHeaders() {
		if (this.headers != null) {
			this.headers.clear();
		}
	}

	@Override
	public void removeHeader(String name) {
		if (this.headers != null) {
			this.headers.remove(name);
		}
	}

	@Override
	public OpenApi30SecurityScheme createSecurityScheme() {
		OpenApi30SecuritySchemeImpl node = new OpenApi30SecuritySchemeImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, SecurityScheme> getSecuritySchemes() {
		return securitySchemes;
	}

	@Override
	public void addSecurityScheme(String name, SecurityScheme value) {
		if (this.securitySchemes == null) {
			this.securitySchemes = new LinkedHashMap<>();
		}
		this.securitySchemes.put(name, value);
	}

	@Override
	public void clearSecuritySchemes() {
		if (this.securitySchemes != null) {
			this.securitySchemes.clear();
		}
	}

	@Override
	public void removeSecurityScheme(String name) {
		if (this.securitySchemes != null) {
			this.securitySchemes.remove(name);
		}
	}

	@Override
	public OpenApi30Link createLink() {
		OpenApi30LinkImpl node = new OpenApi30LinkImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApiLink> getLinks() {
		return links;
	}

	@Override
	public void addLink(String name, OpenApiLink value) {
		if (this.links == null) {
			this.links = new LinkedHashMap<>();
		}
		this.links.put(name, value);
	}

	@Override
	public void clearLinks() {
		if (this.links != null) {
			this.links.clear();
		}
	}

	@Override
	public void removeLink(String name) {
		if (this.links != null) {
			this.links.remove(name);
		}
	}

	@Override
	public OpenApi30Callback createCallback() {
		OpenApi30CallbackImpl node = new OpenApi30CallbackImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApiCallback> getCallbacks() {
		return callbacks;
	}

	@Override
	public void addCallback(String name, OpenApiCallback value) {
		if (this.callbacks == null) {
			this.callbacks = new LinkedHashMap<>();
		}
		this.callbacks.put(name, value);
	}

	@Override
	public void clearCallbacks() {
		if (this.callbacks != null) {
			this.callbacks.clear();
		}
	}

	@Override
	public void removeCallback(String name) {
		if (this.callbacks != null) {
			this.callbacks.remove(name);
		}
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		OpenApi30Visitor viz = (OpenApi30Visitor) visitor;
		viz.visitComponents(this);
	}

	@Override
	public Node emptyClone() {
		return new OpenApi30ComponentsImpl();
	}
}