package io.apicurio.datamodels.models.openapi.v30;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.ExternalDocumentation;
import io.apicurio.datamodels.models.Info;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.RootNodeImpl;
import io.apicurio.datamodels.models.Tag;
import io.apicurio.datamodels.models.openapi.OpenApiPaths;
import io.apicurio.datamodels.models.openapi.OpenApiSecurityRequirement;
import io.apicurio.datamodels.models.openapi.v30.visitors.OpenApi30Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenApi30DocumentImpl extends RootNodeImpl implements OpenApi30Document {

	private String openapi;
	private Info info;
	private List<OpenApi30Server> servers;
	private OpenApiPaths paths;
	private OpenApi30Components components;
	private List<OpenApiSecurityRequirement> security;
	private List<Tag> tags;
	private ExternalDocumentation externalDocs;
	private Map<String, JsonNode> extensions;

	public OpenApi30DocumentImpl() {
		super(ModelType.OPENAPI30);
	}

	@Override
	public String getOpenapi() {
		return openapi;
	}

	@Override
	public void setOpenapi(String value) {
		this.openapi = value;
	}

	@Override
	public Info getInfo() {
		return info;
	}

	@Override
	public void setInfo(Info value) {
		this.info = value;
	}

	@Override
	public OpenApi30Info createInfo() {
		OpenApi30InfoImpl node = new OpenApi30InfoImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public OpenApi30Server createServer() {
		OpenApi30ServerImpl node = new OpenApi30ServerImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public List<OpenApi30Server> getServers() {
		return servers;
	}

	@Override
	public void addServer(OpenApi30Server value) {
		if (this.servers == null) {
			this.servers = new ArrayList<>();
		}
		this.servers.add(value);
	}

	@Override
	public void clearServers() {
		if (this.servers != null) {
			this.servers.clear();
		}
	}

	@Override
	public void removeServer(OpenApi30Server value) {
		if (this.servers != null) {
			this.servers.remove(value);
		}
	}

	@Override
	public OpenApiPaths getPaths() {
		return paths;
	}

	@Override
	public void setPaths(OpenApiPaths value) {
		this.paths = value;
	}

	@Override
	public OpenApi30Paths createPaths() {
		OpenApi30PathsImpl node = new OpenApi30PathsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public OpenApi30Components getComponents() {
		return components;
	}

	@Override
	public void setComponents(OpenApi30Components value) {
		this.components = value;
	}

	@Override
	public OpenApi30Components createComponents() {
		OpenApi30ComponentsImpl node = new OpenApi30ComponentsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public OpenApi30SecurityRequirement createSecurityRequirement() {
		OpenApi30SecurityRequirementImpl node = new OpenApi30SecurityRequirementImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public List<OpenApiSecurityRequirement> getSecurity() {
		return security;
	}

	@Override
	public void addSecurity(OpenApiSecurityRequirement value) {
		if (this.security == null) {
			this.security = new ArrayList<>();
		}
		this.security.add(value);
	}

	@Override
	public void clearSecurity() {
		if (this.security != null) {
			this.security.clear();
		}
	}

	@Override
	public void removeSecurity(OpenApiSecurityRequirement value) {
		if (this.security != null) {
			this.security.remove(value);
		}
	}

	@Override
	public OpenApi30Tag createTag() {
		OpenApi30TagImpl node = new OpenApi30TagImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public List<Tag> getTags() {
		return tags;
	}

	@Override
	public void addTag(Tag value) {
		if (this.tags == null) {
			this.tags = new ArrayList<>();
		}
		this.tags.add(value);
	}

	@Override
	public void clearTags() {
		if (this.tags != null) {
			this.tags.clear();
		}
	}

	@Override
	public void removeTag(Tag value) {
		if (this.tags != null) {
			this.tags.remove(value);
		}
	}

	@Override
	public ExternalDocumentation getExternalDocs() {
		return externalDocs;
	}

	@Override
	public void setExternalDocs(ExternalDocumentation value) {
		this.externalDocs = value;
	}

	@Override
	public OpenApi30ExternalDocumentation createExternalDocumentation() {
		OpenApi30ExternalDocumentationImpl node = new OpenApi30ExternalDocumentationImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		OpenApi30Visitor viz = (OpenApi30Visitor) visitor;
		viz.visitDocument(this);
	}

	@Override
	public Node emptyClone() {
		return new OpenApi30DocumentImpl();
	}
}