package io.apicurio.datamodels.models.openapi.v30;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.openapi.OpenApiEncoding;
import io.apicurio.datamodels.models.openapi.OpenApiExample;
import io.apicurio.datamodels.models.openapi.OpenApiSchema;
import io.apicurio.datamodels.models.openapi.v30.visitors.OpenApi30Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class OpenApi30MediaTypeImpl extends NodeImpl implements OpenApi30MediaType {

	private OpenApiSchema schema;
	private JsonNode example;
	private Map<String, OpenApiExample> examples;
	private Map<String, OpenApiEncoding> encoding;
	private Map<String, JsonNode> extensions;

	@Override
	public OpenApiSchema getSchema() {
		return schema;
	}

	@Override
	public void setSchema(OpenApiSchema value) {
		this.schema = value;
	}

	@Override
	public OpenApi30Schema createSchema() {
		OpenApi30SchemaImpl node = new OpenApi30SchemaImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public JsonNode getExample() {
		return example;
	}

	@Override
	public void setExample(JsonNode value) {
		this.example = value;
	}

	@Override
	public OpenApi30Example createExample() {
		OpenApi30ExampleImpl node = new OpenApi30ExampleImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApiExample> getExamples() {
		return examples;
	}

	@Override
	public void addExample(String name, OpenApiExample value) {
		if (this.examples == null) {
			this.examples = new LinkedHashMap<>();
		}
		this.examples.put(name, value);
	}

	@Override
	public void clearExamples() {
		if (this.examples != null) {
			this.examples.clear();
		}
	}

	@Override
	public void removeExample(String name) {
		if (this.examples != null) {
			this.examples.remove(name);
		}
	}

	@Override
	public OpenApi30Encoding createEncoding() {
		OpenApi30EncodingImpl node = new OpenApi30EncodingImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApiEncoding> getEncoding() {
		return encoding;
	}

	@Override
	public void addEncoding(String name, OpenApiEncoding value) {
		if (this.encoding == null) {
			this.encoding = new LinkedHashMap<>();
		}
		this.encoding.put(name, value);
	}

	@Override
	public void clearEncoding() {
		if (this.encoding != null) {
			this.encoding.clear();
		}
	}

	@Override
	public void removeEncoding(String name) {
		if (this.encoding != null) {
			this.encoding.remove(name);
		}
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		OpenApi30Visitor viz = (OpenApi30Visitor) visitor;
		viz.visitMediaType(this);
	}

	@Override
	public Node emptyClone() {
		return new OpenApi30MediaTypeImpl();
	}
}