package io.apicurio.datamodels.models.openapi.v30;

import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import java.util.List;
import java.util.Map;

public interface OpenApi30Operation extends OpenApiOperation, OpenApi30Extensible {

	public OpenApi30RequestBody getRequestBody();

	public void setRequestBody(OpenApi30RequestBody value);

	public OpenApi30RequestBody createRequestBody();

	public OpenApi30Callback createCallback();

	public Map<String, OpenApi30Callback> getCallbacks();

	public void addCallback(String name, OpenApi30Callback value);

	public void clearCallbacks();

	public void removeCallback(String name);

	public OpenApi30Server createServer();

	public List<OpenApi30Server> getServers();

	public void addServer(OpenApi30Server value);

	public void clearServers();

	public void removeServer(OpenApi30Server value);
}