package io.apicurio.datamodels.models.openapi.v30;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import java.util.Map;

public interface OpenApi30Parameter extends OpenApiParameter, OpenApi30Extensible, OpenApi30Referenceable {

	public Boolean isDeprecated();

	public void setDeprecated(Boolean value);

	public String getStyle();

	public void setStyle(String value);

	public Boolean isExplode();

	public void setExplode(Boolean value);

	public Boolean isAllowReserved();

	public void setAllowReserved(Boolean value);

	public JsonNode getExample();

	public void setExample(JsonNode value);

	public OpenApi30Example createExample();

	public Map<String, OpenApi30Example> getExamples();

	public void addExample(String name, OpenApi30Example value);

	public void clearExamples();

	public void removeExample(String name);

	public OpenApi30MediaType createMediaType();

	public Map<String, OpenApi30MediaType> getContent();

	public void addContent(String name, OpenApi30MediaType value);

	public void clearContent();

	public void removeContent(String name);
}