package io.apicurio.datamodels.models.openapi.v30;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.v30.visitors.OpenApi30Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenApi30PathItemImpl extends NodeImpl implements OpenApi30PathItem {

	private String $ref;
	private String summary;
	private String description;
	private OpenApiOperation get;
	private OpenApiOperation put;
	private OpenApiOperation post;
	private OpenApiOperation delete;
	private OpenApiOperation options;
	private OpenApiOperation head;
	private OpenApiOperation patch;
	private OpenApi30Operation trace;
	private List<OpenApi30Server> servers;
	private List<OpenApiParameter> parameters;
	private Map<String, JsonNode> extensions;

	@Override
	public String get$ref() {
		return $ref;
	}

	@Override
	public void set$ref(String value) {
		this.$ref = value;
	}

	@Override
	public String getSummary() {
		return summary;
	}

	@Override
	public void setSummary(String value) {
		this.summary = value;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public void setDescription(String value) {
		this.description = value;
	}

	@Override
	public OpenApiOperation getGet() {
		return get;
	}

	@Override
	public void setGet(OpenApiOperation value) {
		this.get = value;
	}

	@Override
	public OpenApi30Operation createOperation() {
		OpenApi30OperationImpl node = new OpenApi30OperationImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public OpenApiOperation getPut() {
		return put;
	}

	@Override
	public void setPut(OpenApiOperation value) {
		this.put = value;
	}

	@Override
	public OpenApiOperation getPost() {
		return post;
	}

	@Override
	public void setPost(OpenApiOperation value) {
		this.post = value;
	}

	@Override
	public OpenApiOperation getDelete() {
		return delete;
	}

	@Override
	public void setDelete(OpenApiOperation value) {
		this.delete = value;
	}

	@Override
	public OpenApiOperation getOptions() {
		return options;
	}

	@Override
	public void setOptions(OpenApiOperation value) {
		this.options = value;
	}

	@Override
	public OpenApiOperation getHead() {
		return head;
	}

	@Override
	public void setHead(OpenApiOperation value) {
		this.head = value;
	}

	@Override
	public OpenApiOperation getPatch() {
		return patch;
	}

	@Override
	public void setPatch(OpenApiOperation value) {
		this.patch = value;
	}

	@Override
	public OpenApi30Operation getTrace() {
		return trace;
	}

	@Override
	public void setTrace(OpenApi30Operation value) {
		this.trace = value;
	}

	@Override
	public OpenApi30Server createServer() {
		OpenApi30ServerImpl node = new OpenApi30ServerImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public List<OpenApi30Server> getServers() {
		return servers;
	}

	@Override
	public void addServer(OpenApi30Server value) {
		if (this.servers == null) {
			this.servers = new ArrayList<>();
		}
		this.servers.add(value);
	}

	@Override
	public void clearServers() {
		if (this.servers != null) {
			this.servers.clear();
		}
	}

	@Override
	public void removeServer(OpenApi30Server value) {
		if (this.servers != null) {
			this.servers.remove(value);
		}
	}

	@Override
	public OpenApi30Parameter createParameter() {
		OpenApi30ParameterImpl node = new OpenApi30ParameterImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public List<OpenApiParameter> getParameters() {
		return parameters;
	}

	@Override
	public void addParameter(OpenApiParameter value) {
		if (this.parameters == null) {
			this.parameters = new ArrayList<>();
		}
		this.parameters.add(value);
	}

	@Override
	public void clearParameters() {
		if (this.parameters != null) {
			this.parameters.clear();
		}
	}

	@Override
	public void removeParameter(OpenApiParameter value) {
		if (this.parameters != null) {
			this.parameters.remove(value);
		}
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		OpenApi30Visitor viz = (OpenApi30Visitor) visitor;
		viz.visitPathItem(this);
	}

	@Override
	public Node emptyClone() {
		return new OpenApi30PathItemImpl();
	}
}