package io.apicurio.datamodels.models.openapi.v30;

import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import java.util.Map;

public interface OpenApi30Response extends OpenApiResponse, OpenApi30Extensible, OpenApi30Referenceable {

	public OpenApi30Header createHeader();

	public Map<String, OpenApi30Header> getHeaders();

	public void addHeader(String name, OpenApi30Header value);

	public void clearHeaders();

	public void removeHeader(String name);

	public OpenApi30MediaType createMediaType();

	public Map<String, OpenApi30MediaType> getContent();

	public void addContent(String name, OpenApi30MediaType value);

	public void clearContent();

	public void removeContent(String name);

	public OpenApi30Link createLink();

	public Map<String, OpenApi30Link> getLinks();

	public void addLink(String name, OpenApi30Link value);

	public void clearLinks();

	public void removeLink(String name);
}