package io.apicurio.datamodels.models.openapi.v30;

import io.apicurio.datamodels.models.openapi.OpenApiSchema;
import java.util.List;

public interface OpenApi30Schema extends OpenApiSchema, OpenApi30Extensible, OpenApi30Referenceable {

	public Boolean isExclusiveMaximum();

	public void setExclusiveMaximum(Boolean value);

	public Boolean isExclusiveMinimum();

	public void setExclusiveMinimum(Boolean value);

	public String getType();

	public void setType(String value);

	public OpenApi30Schema getItems();

	public void setItems(OpenApi30Schema value);

	public OpenApi30Schema createSchema();

	public List<OpenApi30Schema> getOneOf();

	public void addOneOf(OpenApi30Schema value);

	public void clearOneOf();

	public void removeOneOf(OpenApi30Schema value);

	public List<OpenApi30Schema> getAnyOf();

	public void addAnyOf(OpenApi30Schema value);

	public void clearAnyOf();

	public void removeAnyOf(OpenApi30Schema value);

	public OpenApi30Schema getNot();

	public void setNot(OpenApi30Schema value);

	public OpenApi30Discriminator getDiscriminator();

	public void setDiscriminator(OpenApi30Discriminator value);

	public OpenApi30Discriminator createDiscriminator();

	public Boolean isNullable();

	public void setNullable(Boolean value);

	public Boolean isWriteOnly();

	public void setWriteOnly(Boolean value);

	public Boolean isDeprecated();

	public void setDeprecated(Boolean value);
}