package io.apicurio.datamodels.models.openapi.v30;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.openapi.v30.visitors.OpenApi30Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenApi30SecurityRequirementImpl extends NodeImpl implements OpenApi30SecurityRequirement {

	private Map<String, List<String>> _items = new LinkedHashMap<>();

	@Override
	public List<String> getItem(String name) {
		return this._items.get(name);
	}

	@Override
	public List<List<String>> getItems() {
		List<List<String>> rval = new ArrayList<>();
		rval.addAll(this._items.values());
		return rval;
	}

	@Override
	public List<String> getItemNames() {
		List<String> rval = new ArrayList<>();
		rval.addAll(this._items.keySet());
		return rval;
	}

	@Override
	public void addItem(String name, List<String> item) {
		this._items.put(name, item);
	}

	@Override
	public List<String> removeItem(String name) {
		return this._items.remove(name);
	}

	@Override
	public void accept(Visitor visitor) {
		OpenApi30Visitor viz = (OpenApi30Visitor) visitor;
		viz.visitSecurityRequirement(this);
	}

	@Override
	public Node emptyClone() {
		return new OpenApi30SecurityRequirementImpl();
	}
}