package io.apicurio.datamodels.models.openapi.v31;

import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import java.util.List;
import java.util.Map;

public interface OpenApi31Document extends RootNode, OpenApiDocument, OpenApi31Extensible {

	public String getOpenapi();

	public void setOpenapi(String value);

	public String getJsonSchemaDialect();

	public void setJsonSchemaDialect(String value);

	public OpenApi31Server createServer();

	public List<OpenApi31Server> getServers();

	public void addServer(OpenApi31Server value);

	public void clearServers();

	public void removeServer(OpenApi31Server value);

	public OpenApi31PathItem createPathItem();

	public Map<String, OpenApi31PathItem> getWebhooks();

	public void addWebhook(String name, OpenApi31PathItem value);

	public void clearWebhooks();

	public void removeWebhook(String name);

	public OpenApi31Components getComponents();

	public void setComponents(OpenApi31Components value);

	public OpenApi31Components createComponents();
}