package io.apicurio.datamodels.models.openapi.v31;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.openapi.OpenApiHeader;
import java.util.Map;

public interface OpenApi31Header extends OpenApiHeader, OpenApi31Extensible, OpenApi31Referenceable {

	public Boolean isRequired();

	public void setRequired(Boolean value);

	public Boolean isDeprecated();

	public void setDeprecated(Boolean value);

	public Boolean isAllowEmptyValue();

	public void setAllowEmptyValue(Boolean value);

	public String getStyle();

	public void setStyle(String value);

	public Boolean isExplode();

	public void setExplode(Boolean value);

	public Boolean isAllowReserved();

	public void setAllowReserved(Boolean value);

	public OpenApi31Schema getSchema();

	public void setSchema(OpenApi31Schema value);

	public OpenApi31Schema createSchema();

	public JsonNode getExample();

	public void setExample(JsonNode value);

	public OpenApi31Example createExample();

	public Map<String, OpenApi31Example> getExamples();

	public void addExample(String name, OpenApi31Example value);

	public void clearExamples();

	public void removeExample(String name);

	public OpenApi31MediaType createMediaType();

	public Map<String, OpenApi31MediaType> getContent();

	public void addContent(String name, OpenApi31MediaType value);

	public void clearContent();

	public void removeContent(String name);
}