package io.apicurio.datamodels.models.openapi.v31;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.openapi.OpenApiServer;
import io.apicurio.datamodels.models.openapi.v31.visitors.OpenApi31Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class OpenApi31LinkImpl extends NodeImpl implements OpenApi31Link {

	private String $ref;
	private String summary;
	private String operationRef;
	private String operationId;
	private Map<String, JsonNode> parameters;
	private JsonNode requestBody;
	private String description;
	private OpenApiServer server;
	private Map<String, JsonNode> extensions;

	@Override
	public String get$ref() {
		return $ref;
	}

	@Override
	public void set$ref(String value) {
		this.$ref = value;
	}

	@Override
	public String getSummary() {
		return summary;
	}

	@Override
	public void setSummary(String value) {
		this.summary = value;
	}

	@Override
	public String getOperationRef() {
		return operationRef;
	}

	@Override
	public void setOperationRef(String value) {
		this.operationRef = value;
	}

	@Override
	public String getOperationId() {
		return operationId;
	}

	@Override
	public void setOperationId(String value) {
		this.operationId = value;
	}

	@Override
	public Map<String, JsonNode> getParameters() {
		return parameters;
	}

	@Override
	public void setParameters(Map<String, JsonNode> value) {
		this.parameters = value;
	}

	@Override
	public JsonNode getRequestBody() {
		return requestBody;
	}

	@Override
	public void setRequestBody(JsonNode value) {
		this.requestBody = value;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public void setDescription(String value) {
		this.description = value;
	}

	@Override
	public OpenApiServer getServer() {
		return server;
	}

	@Override
	public void setServer(OpenApiServer value) {
		this.server = value;
	}

	@Override
	public OpenApi31Server createServer() {
		OpenApi31ServerImpl node = new OpenApi31ServerImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		OpenApi31Visitor viz = (OpenApi31Visitor) visitor;
		viz.visitLink(this);
	}

	@Override
	public Node emptyClone() {
		return new OpenApi31LinkImpl();
	}
}