package io.apicurio.datamodels.models.openapi.v31;

import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import java.util.List;
import java.util.Map;

public interface OpenApi31Operation extends OpenApiOperation, OpenApi31Extensible {

	public OpenApi31RequestBody getRequestBody();

	public void setRequestBody(OpenApi31RequestBody value);

	public OpenApi31RequestBody createRequestBody();

	public OpenApi31Callback createCallback();

	public Map<String, OpenApi31Callback> getCallbacks();

	public void addCallback(String name, OpenApi31Callback value);

	public void clearCallbacks();

	public void removeCallback(String name);

	public OpenApi31Server createServer();

	public List<OpenApi31Server> getServers();

	public void addServer(OpenApi31Server value);

	public void clearServers();

	public void removeServer(OpenApi31Server value);
}