package io.apicurio.datamodels.models.openapi.v31;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.openapi.v31.visitors.OpenApi31Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class OpenApi31ParameterImpl extends NodeImpl implements OpenApi31Parameter {

	private String $ref;
	private String summary;
	private String name;
	private String in;
	private String description;
	private Boolean required;
	private Boolean deprecated;
	private Boolean allowEmptyValue;
	private String style;
	private Boolean explode;
	private Boolean allowReserved;
	private Schema schema;
	private JsonNode example;
	private Map<String, OpenApi31Example> examples;
	private Map<String, OpenApi31MediaType> content;
	private Map<String, JsonNode> extensions;

	@Override
	public String get$ref() {
		return $ref;
	}

	@Override
	public void set$ref(String value) {
		this.$ref = value;
	}

	@Override
	public String getSummary() {
		return summary;
	}

	@Override
	public void setSummary(String value) {
		this.summary = value;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public void setName(String value) {
		this.name = value;
	}

	@Override
	public String getIn() {
		return in;
	}

	@Override
	public void setIn(String value) {
		this.in = value;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public void setDescription(String value) {
		this.description = value;
	}

	@Override
	public Boolean isRequired() {
		return required;
	}

	@Override
	public void setRequired(Boolean value) {
		this.required = value;
	}

	@Override
	public Boolean isDeprecated() {
		return deprecated;
	}

	@Override
	public void setDeprecated(Boolean value) {
		this.deprecated = value;
	}

	@Override
	public Boolean isAllowEmptyValue() {
		return allowEmptyValue;
	}

	@Override
	public void setAllowEmptyValue(Boolean value) {
		this.allowEmptyValue = value;
	}

	@Override
	public String getStyle() {
		return style;
	}

	@Override
	public void setStyle(String value) {
		this.style = value;
	}

	@Override
	public Boolean isExplode() {
		return explode;
	}

	@Override
	public void setExplode(Boolean value) {
		this.explode = value;
	}

	@Override
	public Boolean isAllowReserved() {
		return allowReserved;
	}

	@Override
	public void setAllowReserved(Boolean value) {
		this.allowReserved = value;
	}

	@Override
	public Schema getSchema() {
		return schema;
	}

	@Override
	public void setSchema(Schema value) {
		this.schema = value;
	}

	@Override
	public OpenApi31Schema createSchema() {
		OpenApi31SchemaImpl node = new OpenApi31SchemaImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public JsonNode getExample() {
		return example;
	}

	@Override
	public void setExample(JsonNode value) {
		this.example = value;
	}

	@Override
	public OpenApi31Example createExample() {
		OpenApi31ExampleImpl node = new OpenApi31ExampleImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApi31Example> getExamples() {
		return examples;
	}

	@Override
	public void addExample(String name, OpenApi31Example value) {
		if (this.examples == null) {
			this.examples = new LinkedHashMap<>();
		}
		this.examples.put(name, value);
	}

	@Override
	public void clearExamples() {
		if (this.examples != null) {
			this.examples.clear();
		}
	}

	@Override
	public void removeExample(String name) {
		if (this.examples != null) {
			this.examples.remove(name);
		}
	}

	@Override
	public OpenApi31MediaType createMediaType() {
		OpenApi31MediaTypeImpl node = new OpenApi31MediaTypeImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApi31MediaType> getContent() {
		return content;
	}

	@Override
	public void addContent(String name, OpenApi31MediaType value) {
		if (this.content == null) {
			this.content = new LinkedHashMap<>();
		}
		this.content.put(name, value);
	}

	@Override
	public void clearContent() {
		if (this.content != null) {
			this.content.clear();
		}
	}

	@Override
	public void removeContent(String name) {
		if (this.content != null) {
			this.content.remove(name);
		}
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		OpenApi31Visitor viz = (OpenApi31Visitor) visitor;
		viz.visitParameter(this);
	}

	@Override
	public Node emptyClone() {
		return new OpenApi31ParameterImpl();
	}
}