package io.apicurio.datamodels.models.openapi.v31;

import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import java.util.Map;

public interface OpenApi31Response extends OpenApiResponse, OpenApi31Extensible, OpenApi31Referenceable {

	public OpenApi31Header createHeader();

	public Map<String, OpenApi31Header> getHeaders();

	public void addHeader(String name, OpenApi31Header value);

	public void clearHeaders();

	public void removeHeader(String name);

	public OpenApi31MediaType createMediaType();

	public Map<String, OpenApi31MediaType> getContent();

	public void addContent(String name, OpenApi31MediaType value);

	public void clearContent();

	public void removeContent(String name);

	public OpenApi31Link createLink();

	public Map<String, OpenApi31Link> getLinks();

	public void addLink(String name, OpenApi31Link value);

	public void clearLinks();

	public void removeLink(String name);
}