package io.apicurio.datamodels.models.openapi.v31;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.openapi.v31.visitors.OpenApi31Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class OpenApi31ResponseImpl extends NodeImpl implements OpenApi31Response {

	private String $ref;
	private String summary;
	private String description;
	private Map<String, OpenApi31Header> headers;
	private Map<String, OpenApi31MediaType> content;
	private Map<String, OpenApi31Link> links;
	private Map<String, JsonNode> extensions;

	@Override
	public String get$ref() {
		return $ref;
	}

	@Override
	public void set$ref(String value) {
		this.$ref = value;
	}

	@Override
	public String getSummary() {
		return summary;
	}

	@Override
	public void setSummary(String value) {
		this.summary = value;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public void setDescription(String value) {
		this.description = value;
	}

	@Override
	public OpenApi31Header createHeader() {
		OpenApi31HeaderImpl node = new OpenApi31HeaderImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApi31Header> getHeaders() {
		return headers;
	}

	@Override
	public void addHeader(String name, OpenApi31Header value) {
		if (this.headers == null) {
			this.headers = new LinkedHashMap<>();
		}
		this.headers.put(name, value);
	}

	@Override
	public void clearHeaders() {
		if (this.headers != null) {
			this.headers.clear();
		}
	}

	@Override
	public void removeHeader(String name) {
		if (this.headers != null) {
			this.headers.remove(name);
		}
	}

	@Override
	public OpenApi31MediaType createMediaType() {
		OpenApi31MediaTypeImpl node = new OpenApi31MediaTypeImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApi31MediaType> getContent() {
		return content;
	}

	@Override
	public void addContent(String name, OpenApi31MediaType value) {
		if (this.content == null) {
			this.content = new LinkedHashMap<>();
		}
		this.content.put(name, value);
	}

	@Override
	public void clearContent() {
		if (this.content != null) {
			this.content.clear();
		}
	}

	@Override
	public void removeContent(String name) {
		if (this.content != null) {
			this.content.remove(name);
		}
	}

	@Override
	public OpenApi31Link createLink() {
		OpenApi31LinkImpl node = new OpenApi31LinkImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, OpenApi31Link> getLinks() {
		return links;
	}

	@Override
	public void addLink(String name, OpenApi31Link value) {
		if (this.links == null) {
			this.links = new LinkedHashMap<>();
		}
		this.links.put(name, value);
	}

	@Override
	public void clearLinks() {
		if (this.links != null) {
			this.links.clear();
		}
	}

	@Override
	public void removeLink(String name) {
		if (this.links != null) {
			this.links.remove(name);
		}
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		OpenApi31Visitor viz = (OpenApi31Visitor) visitor;
		viz.visitResponse(this);
	}

	@Override
	public Node emptyClone() {
		return new OpenApi31ResponseImpl();
	}
}