package io.apicurio.datamodels.models.openapi.v31;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import io.apicurio.datamodels.models.openapi.v31.visitors.OpenApi31Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenApi31ResponsesImpl extends NodeImpl implements OpenApi31Responses {

	private String $ref;
	private String summary;
	private String description;
	private OpenApiResponse _default;
	private Map<String, OpenApiResponse> _items = new LinkedHashMap<>();
	private Map<String, JsonNode> extensions;

	@Override
	public String get$ref() {
		return $ref;
	}

	@Override
	public void set$ref(String value) {
		this.$ref = value;
	}

	@Override
	public String getSummary() {
		return summary;
	}

	@Override
	public void setSummary(String value) {
		this.summary = value;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public void setDescription(String value) {
		this.description = value;
	}

	@Override
	public OpenApiResponse getDefault() {
		return _default;
	}

	@Override
	public void setDefault(OpenApiResponse value) {
		this._default = value;
	}

	@Override
	public OpenApi31Response createResponse() {
		OpenApi31ResponseImpl node = new OpenApi31ResponseImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public OpenApiResponse getItem(String name) {
		return this._items.get(name);
	}

	@Override
	public List<OpenApiResponse> getItems() {
		List<OpenApiResponse> rval = new ArrayList<>();
		rval.addAll(this._items.values());
		return rval;
	}

	@Override
	public List<String> getItemNames() {
		List<String> rval = new ArrayList<>();
		rval.addAll(this._items.keySet());
		return rval;
	}

	@Override
	public void addItem(String name, OpenApiResponse item) {
		this._items.put(name, item);
	}

	@Override
	public OpenApiResponse removeItem(String name) {
		return this._items.remove(name);
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		OpenApi31Visitor viz = (OpenApi31Visitor) visitor;
		viz.visitResponses(this);
	}

	@Override
	public Node emptyClone() {
		return new OpenApi31ResponsesImpl();
	}
}