package io.apicurio.datamodels.models.openapi.v31;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.openapi.OpenApiSchema;
import io.apicurio.datamodels.models.union.StringStringListUnion;
import java.util.List;

public interface OpenApi31Schema extends OpenApiSchema, OpenApi31Extensible, OpenApi31Referenceable {

	public Number getExclusiveMaximum();

	public void setExclusiveMaximum(Number value);

	public Number getExclusiveMinimum();

	public void setExclusiveMinimum(Number value);

	public JsonNode getConst();

	public void setConst(JsonNode value);

	public StringStringListUnion getType();

	public void setType(StringStringListUnion value);

	public OpenApi31Schema getItems();

	public void setItems(OpenApi31Schema value);

	public OpenApi31Schema createSchema();

	public List<OpenApi31Schema> getOneOf();

	public void addOneOf(OpenApi31Schema value);

	public void clearOneOf();

	public void removeOneOf(OpenApi31Schema value);

	public List<OpenApi31Schema> getAnyOf();

	public void addAnyOf(OpenApi31Schema value);

	public void clearAnyOf();

	public void removeAnyOf(OpenApi31Schema value);

	public OpenApi31Schema getNot();

	public void setNot(OpenApi31Schema value);

	public OpenApi31Discriminator getDiscriminator();

	public void setDiscriminator(OpenApi31Discriminator value);

	public OpenApi31Discriminator createDiscriminator();

	public Boolean isWriteOnly();

	public void setWriteOnly(Boolean value);

	public Boolean isDeprecated();

	public void setDeprecated(Boolean value);
}