package io.apicurio.datamodels.models.openapi.visitors;

import io.apicurio.datamodels.models.openapi.OpenApiExample;
import io.apicurio.datamodels.models.openapi.OpenApiHeader;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.models.openapi.OpenApiPaths;
import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import io.apicurio.datamodels.models.openapi.OpenApiResponses;
import io.apicurio.datamodels.models.openapi.OpenApiXML;
import io.apicurio.datamodels.models.visitors.Visitor;

public interface OpenApiVisitor extends Visitor {

	public void visitPaths(OpenApiPaths node);

	public void visitHeader(OpenApiHeader node);

	public void visitXML(OpenApiXML node);

	public void visitPathItem(OpenApiPathItem node);

	public void visitExample(OpenApiExample node);

	public void visitResponse(OpenApiResponse node);

	public void visitResponses(OpenApiResponses node);
}