package io.apicurio.datamodels.models.union;

import io.apicurio.datamodels.models.Schema;

public class BooleanUnionValueImpl extends PrimitiveUnionValueImpl<Boolean> implements BooleanUnionValue {

	public BooleanUnionValueImpl(Boolean value) {
		super(value);
	}

	@Override
	public boolean isBoolean() {
		return true;
	}

	@Override
	public Boolean asBoolean() {
		return getValue();
	}

	@Override
	public boolean isSchema() {
		return false;
	}

	@Override
	public Schema asSchema() {
		throw new ClassCastException();
	}

}
