package io.apicurio.datamodels.models.visitors;

import io.apicurio.datamodels.models.Contact;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.ExternalDocumentation;
import io.apicurio.datamodels.models.Info;
import io.apicurio.datamodels.models.License;
import io.apicurio.datamodels.models.Operation;
import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.SecurityRequirement;
import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.models.Tag;

public interface Visitor {

	public void visitInfo(Info node);

	public void visitContact(Contact node);

	public void visitTag(Tag node);

	public void visitSecurityScheme(SecurityScheme node);

	public void visitSecurityRequirement(SecurityRequirement node);

	public void visitExternalDocumentation(ExternalDocumentation node);

	public void visitLicense(License node);

	public void visitDocument(Document node);

	public void visitParameter(Parameter node);

	public void visitOperation(Operation node);

	public void visitSchema(Schema node);
}