/*
 * Copyright 2019 Red Hat
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.apicurio.datamodels.validation.rules.required;

import io.apicurio.datamodels.models.OAuthFlow;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;

/**
 * @author eric.wittmann@gmail.com
 */
public class MissingOAuthFlowRokenUrlRule extends RequiredPropertyValidationRule {

    /**
     * Constructor.
     * @param ruleInfo
     */
    public MissingOAuthFlowRokenUrlRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    /**
     * @see io.apicurio.datamodels.models.visitors.AllNodeVisitor#visitOAuthFlow(io.apicurio.datamodels.models.OAuthFlow)
     */
    @Override
    public void visitOAuthFlow(OAuthFlow node) {
        String flowType = getMappedNodeName(node);
        if ("password".equals(flowType)) {
            this.requireProperty(node, "tokenUrl", map("flowType", "Password"));
        }
        if ("clientCredentials".equals(flowType)) {
            this.requireProperty(node, "tokenUrl", map("flowType", "Client Credentials"));
        }
        if ("authorizationCode".equals(flowType)) {
            this.requireProperty(node, "tokenUrl", map("flowType", "Auth Code"));
        }
    }
}
