/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.name;

import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.VisitorUtil;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Operation;
import io.apicurio.datamodels.models.openapi.OpenApiExample;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Example;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Operation;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidPropertyNameRule;
import io.apicurio.datamodels.visitors.OperationFinder;
import java.util.ArrayList;
import java.util.List;

public class OasUnmatchedExampleTypeRule
extends OasInvalidPropertyNameRule {
    public OasUnmatchedExampleTypeRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private static Operation findParentOperation(Node node) {
        OperationFinder finder = new OperationFinder();
        VisitorUtil.visitTree(node, finder, TraverserDirection.up);
        return finder.found;
    }

    @Override
    public void visitExample(OpenApiExample node) {
        OpenApi20Example example20 = (OpenApi20Example)node;
        OpenApi20Document doc = (OpenApi20Document)example20.root();
        List<String> produces = doc.getProduces();
        OpenApi20Operation operation = (OpenApi20Operation)OasUnmatchedExampleTypeRule.findParentOperation(example20);
        if (this.isDefined(operation)) {
            if (this.hasValue(operation.getProduces())) {
                produces = operation.getProduces();
            }
            if (!this.hasValue(produces)) {
                produces = new ArrayList<String>();
            }
            List<String> ctypes = example20.getItemNames();
            for (String ct : ctypes) {
                this.reportIfInvalid(produces.indexOf(ct) != -1, example20, "produces", this.map("contentType", ct));
            }
        }
    }
}

