/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.reference;

import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.SecurityRequirement;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Document;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Document;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;

public class OasInvalidSecurityRequirementNameRule
extends ValidationRule {
    public OasInvalidSecurityRequirementNameRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private boolean isValidSecurityRequirementName(String securityReqName, Document doc) {
        ModelType dt = doc.root().modelType();
        if (dt == ModelType.OPENAPI20) {
            OpenApi20Document doc20 = (OpenApi20Document)doc;
            return this.hasValue(doc20.getSecurityDefinitions()) && this.isDefined(doc20.getSecurityDefinitions().getItem(securityReqName));
        }
        if (dt == ModelType.OPENAPI30) {
            OpenApi30Document doc30 = (OpenApi30Document)doc;
            return this.hasValue(doc30.getComponents()) && this.isDefined(doc30.getComponents()) && this.isDefined(doc30.getComponents().getSecuritySchemes().get(securityReqName));
        }
        if (dt == ModelType.OPENAPI31) {
            OpenApi31Document doc31 = (OpenApi31Document)doc;
            return this.hasValue(doc31.getComponents()) && this.isDefined(doc31.getComponents()) && this.isDefined(doc31.getComponents().getSecuritySchemes().get(securityReqName));
        }
        if (dt == ModelType.ASYNCAPI20 || dt == ModelType.ASYNCAPI21 || dt == ModelType.ASYNCAPI22 || dt == ModelType.ASYNCAPI23 || dt == ModelType.ASYNCAPI24 || dt == ModelType.ASYNCAPI25 || dt == ModelType.ASYNCAPI26) {
            // empty if block
        }
        return false;
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        node.getItemNames().forEach(name -> this.reportIfInvalid(this.isValidSecurityRequirementName((String)name, (Document)((Object)node.root())), node, null, this.map("name", (String)name)));
    }
}

