/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.SecurityRequirement;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Scopes;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityDefinitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityScheme;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;
import java.util.ArrayList;
import java.util.List;

public class OasUnexpectedSecurityRequirementScopesRule
extends AbstractInvalidPropertyValueRule {
    public OasUnexpectedSecurityRequirementScopesRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected boolean isValidScopes(List<String> requiredScopes, OpenApi20Scopes definedScopes) {
        boolean rval = true;
        List<Object> dscopes = new ArrayList();
        if (this.hasValue(definedScopes)) {
            dscopes = definedScopes.getItemNames();
        }
        for (String requiredScope : requiredScopes) {
            if (dscopes.indexOf(requiredScope) != -1) continue;
            rval = false;
        }
        return rval;
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        List<String> snames = node.getItemNames();
        snames.forEach(sname -> {
            OpenApi20SecurityScheme scheme;
            OpenApi20SecurityDefinitions sdefs = ((OpenApi20Document)node.root()).getSecurityDefinitions();
            if (this.hasValue(sdefs) && this.hasValue(scheme = (OpenApi20SecurityScheme)sdefs.getItem((String)sname)) && this.equals(scheme.getType(), "oauth2")) {
                OpenApi20Scopes definedScopes = scheme.getScopes();
                List requiredScopes = (List)node.getItem((String)sname);
                this.reportIfInvalid(this.isValidScopes(requiredScopes, definedScopes), node, null, this.map("sname", (String)sname));
            }
        });
    }
}

