/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30SecurityScheme;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31SecurityScheme;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;

public class OasUnexpectedUsageOfBearerTokenRule
extends AbstractInvalidPropertyValueRule {
    public OasUnexpectedUsageOfBearerTokenRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        OpenApi31SecurityScheme scheme;
        if (node.root().modelType() == ModelType.OPENAPI30) {
            OpenApi30SecurityScheme scheme2 = (OpenApi30SecurityScheme)node;
            if (this.hasValue(scheme2.getBearerFormat())) {
                this.reportIfInvalid(this.equals(scheme2.getType(), "http") && this.equals(scheme2.getScheme(), "bearer"), node, "bearerFormat", this.map(new String[0]));
            }
        } else if (node.root().modelType() == ModelType.OPENAPI31 && this.hasValue((scheme = (OpenApi31SecurityScheme)node).getBearerFormat())) {
            this.reportIfInvalid(this.equals(scheme.getType(), "http") && this.equals(scheme.getScheme(), "bearer"), node, "bearerFormat", this.map(new String[0]));
        }
    }
}

