/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.rest.client.exception.ExceptionMapper;
import io.apicurio.registry.rest.client.exception.RateLimitedClientException;
import io.apicurio.registry.rest.client.exception.RestClientException;
import io.apicurio.registry.rest.v2.beans.Error;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.apicurio.rest.client.error.ApicurioRestClientException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler
implements RestClientErrorHandler {
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
    public static final int UNAUTHORIZED_CODE = 401;
    public static final int FORBIDDEN_CODE = 403;
    public static final int TOO_MANY_REQUESTS_CODE = 429;

    public ApicurioRestClientException handleErrorResponse(InputStream body, int statusCode) {
        try {
            if (statusCode == 401) {
                return new NotAuthorizedException("Authentication exception");
            }
            if (statusCode == 403) {
                return new ForbiddenException("Authorization error");
            }
            if (statusCode == 429) {
                return new RateLimitedClientException("Too many requests");
            }
            Error error = (Error)mapper.readValue(body, Error.class);
            logger.debug("Error returned by Registry application: {}", (Object)error.getMessage());
            return ExceptionMapper.map(new RestClientException(error));
        }
        catch (Exception e) {
            Throwable cause = ErrorHandler.extractRootCause(e);
            if (cause instanceof RestClientException) {
                throw (RestClientException)((Object)cause);
            }
            Error error = new Error();
            error.setMessage(cause.getMessage());
            error.setErrorCode(Integer.valueOf(statusCode));
            return new RestClientException(error);
        }
    }

    public ApicurioRestClientException parseInputSerializingError(JsonProcessingException ex) {
        Error error = new Error();
        error.setName(ex.getClass().getSimpleName());
        error.setDetail(ex.getMessage());
        error.setMessage("Error trying to parse request body");
        logger.debug("Error trying to parse request body:", (Throwable)ex);
        return new RestClientException(new Error());
    }

    public ApicurioRestClientException parseError(Exception ex) {
        Error error = new Error();
        error.setName(ex.getClass().getSimpleName());
        error.setMessage(ex.getMessage());
        logger.debug("Error returned:", (Throwable)ex);
        return new RestClientException(error);
    }

    private static Throwable extractRootCause(Throwable e) {
        Throwable cause = null;
        while (true) {
            if (cause == null) {
                cause = e;
                continue;
            }
            if (cause.getCause() == null || cause.getCause().equals(cause)) break;
            cause = cause.getCause();
        }
        if (cause.getSuppressed().length != 0) {
            cause = cause.getSuppressed()[0];
        }
        logger.debug("Unknown client exception:", cause);
        return cause;
    }
}

