/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver;

import io.apicurio.registry.resolver.AbstractSchemaResolver;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactCoordinates;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceImpl;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.utils.IoUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DefaultSchemaResolver<S, T>
extends AbstractSchemaResolver<S, T> {
    private boolean autoCreateArtifact;
    private IfExists autoCreateBehavior;
    private boolean findLatest;

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void configure(Map<String, ?> configs, SchemaParser<S, T> schemaParser) {
        super.configure(configs, schemaParser);
        if (this.artifactResolverStrategy.loadSchema() && !schemaParser.supportsExtractSchemaFromData()) {
            throw new IllegalStateException("Wrong configuration");
        }
        this.autoCreateArtifact = this.config.autoRegisterArtifact();
        this.autoCreateBehavior = IfExists.fromValue((String)this.config.autoRegisterArtifactIfExists());
        this.findLatest = this.config.findLatest();
    }

    @Override
    public SchemaLookupResult<S> resolveSchema(Record<T> data) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(data.payload());
        ParsedSchema parsedSchema = null;
        if (this.artifactResolverStrategy.loadSchema() && this.schemaParser.supportsExtractSchemaFromData()) {
            parsedSchema = this.schemaParser.getSchemaFromData(data);
        }
        ArtifactReference artifactReference = this.resolveArtifactReference(data, parsedSchema, false, null);
        return this.getSchemaFromCache(artifactReference).orElse(this.getSchemaFromRegistry(parsedSchema, data, artifactReference));
    }

    private Optional<SchemaLookupResult<S>> getSchemaFromCache(ArtifactReference artifactReference) {
        if (artifactReference.getGlobalId() != null && this.schemaCache.containsByGlobalId(artifactReference.getGlobalId())) {
            return Optional.of(this.resolveSchemaByGlobalId(artifactReference.getGlobalId()));
        }
        if (artifactReference.getContentId() != null && this.schemaCache.containsByContentId(artifactReference.getContentId())) {
            return Optional.of(this.resolveSchemaByContentId(artifactReference.getContentId()));
        }
        if (this.schemaCache.containsByArtifactCoordinates(ArtifactCoordinates.fromArtifactReference(artifactReference))) {
            return Optional.of(this.resolveSchemaByArtifactCoordinatesCached(ArtifactCoordinates.fromArtifactReference(artifactReference)));
        }
        return Optional.empty();
    }

    private SchemaLookupResult<S> getSchemaFromRegistry(ParsedSchema<S> parsedSchema, Record<T> data, ArtifactReference artifactReference) {
        if (this.autoCreateArtifact && this.schemaParser.supportsExtractSchemaFromData()) {
            if (parsedSchema == null) {
                parsedSchema = this.schemaParser.getSchemaFromData(data);
            }
            if (parsedSchema.hasReferences()) {
                List<SchemaLookupResult<S>> schemaLookupResults = this.handleArtifactReferences(data, parsedSchema);
                return this.handleAutoCreateArtifact(parsedSchema, artifactReference, schemaLookupResults);
            }
            return this.handleAutoCreateArtifact(parsedSchema, artifactReference);
        }
        if (this.findLatest || artifactReference.getVersion() != null) {
            return this.resolveSchemaByCoordinates(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion());
        }
        if (this.schemaParser.supportsExtractSchemaFromData()) {
            if (parsedSchema == null) {
                parsedSchema = this.schemaParser.getSchemaFromData(data);
            }
            return this.handleResolveSchemaByContent(parsedSchema, artifactReference);
        }
        return this.resolveSchemaByCoordinates(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion());
    }

    private List<SchemaLookupResult<S>> handleArtifactReferences(Record<T> data, ParsedSchema<S> parsedSchema) {
        ArrayList<SchemaLookupResult<S>> referencesLookup = new ArrayList<SchemaLookupResult<S>>();
        for (ParsedSchema<S> referencedSchema : parsedSchema.getSchemaReferences()) {
            List<SchemaLookupResult<S>> nestedReferences = this.handleArtifactReferences(data, referencedSchema);
            if (nestedReferences.isEmpty()) {
                referencesLookup.add(this.handleAutoCreateArtifact(referencedSchema, this.resolveArtifactReference(data, referencedSchema, true, referencedSchema.referenceName())));
                continue;
            }
            referencesLookup.add(this.handleAutoCreateArtifact(referencedSchema, this.resolveArtifactReference(data, referencedSchema, true, referencedSchema.referenceName()), nestedReferences));
        }
        return referencesLookup;
    }

    @Override
    public SchemaLookupResult<S> resolveSchemaByArtifactReference(ArtifactReference reference) {
        if (reference == null) {
            throw new IllegalStateException("artifact reference cannot be null");
        }
        if (reference.getContentId() != null) {
            return this.resolveSchemaByContentId(reference.getContentId());
        }
        if (reference.getGlobalId() == null) {
            return this.resolveSchemaByCoordinates(reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
        }
        return this.resolveSchemaByGlobalId(reference.getGlobalId());
    }

    private SchemaLookupResult<S> resolveSchemaByCoordinates(String groupId, String artifactId, String version) {
        if (artifactId == null) {
            throw new IllegalStateException("artifactId cannot be null");
        }
        ArtifactReferenceImpl reference = ArtifactReference.builder().groupId(groupId).artifactId(artifactId).version(version).build();
        return this.resolveSchemaByArtifactReferenceCached(reference);
    }

    protected SchemaLookupResult<S> resolveSchemaByContentId(long contentId) {
        return this.schemaCache.getByContentId(contentId, contentIdKey -> {
            InputStream rawSchema = this.client.getContentById(contentIdKey.longValue());
            List artifactReferences = this.client.getArtifactReferencesByContentId(contentId);
            Map resolvedReferences = this.resolveReferences(artifactReferences);
            byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
            Object parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            ParsedSchemaImpl ps = new ParsedSchemaImpl().setParsedSchema(parsed).setRawSchema(schema);
            return result.contentId((long)contentIdKey).parsedSchema(ps).build();
        });
    }

    private SchemaLookupResult<S> handleResolveSchemaByContent(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference) {
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        return this.schemaCache.getByContent(rawSchemaString, contentKey -> {
            VersionMetaData artifactMetadata = this.client.getArtifactVersionMetaDataByContent(artifactReference.getGroupId(), artifactReference.getArtifactId(), Boolean.valueOf(true), IoUtil.toStream((String)contentKey));
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromArtifactMetaData(artifactMetadata, result);
            result.parsedSchema(parsedSchema);
            return result.build();
        });
    }

    private SchemaLookupResult<S> handleAutoCreateArtifact(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference) {
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        return this.schemaCache.getByContent(rawSchemaString, contentKey -> {
            ArtifactMetaData artifactMetadata = this.client.createArtifact(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion(), this.schemaParser.artifactType(), this.autoCreateBehavior, Boolean.valueOf(false), IoUtil.toStream((byte[])parsedSchema.getRawSchema()));
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromArtifactMetaData(artifactMetadata, result);
            result.parsedSchema(parsedSchema);
            return result.build();
        });
    }

    private SchemaLookupResult<S> handleAutoCreateArtifact(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference, List<SchemaLookupResult<S>> referenceLookups) {
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        List<io.apicurio.registry.rest.v2.beans.ArtifactReference> artifactReferences = this.parseReferences(referenceLookups);
        return this.schemaCache.getByContent(rawSchemaString, contentKey -> {
            ArtifactMetaData artifactMetadata = this.client.createArtifact(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion(), this.schemaParser.artifactType(), this.autoCreateBehavior, Boolean.valueOf(false), null, null, "application/create.extended+json", IoUtil.toStream((byte[])parsedSchema.getRawSchema()), artifactReferences);
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromArtifactMetaData(artifactMetadata, result);
            result.parsedSchema(parsedSchema);
            return result.build();
        });
    }

    private List<io.apicurio.registry.rest.v2.beans.ArtifactReference> parseReferences(List<SchemaLookupResult<S>> referenceLookups) {
        ArrayList<io.apicurio.registry.rest.v2.beans.ArtifactReference> artifactReferences = new ArrayList<io.apicurio.registry.rest.v2.beans.ArtifactReference>();
        referenceLookups.forEach(referenceLookup -> {
            io.apicurio.registry.rest.v2.beans.ArtifactReference artifactReferenceLookup = new io.apicurio.registry.rest.v2.beans.ArtifactReference();
            artifactReferenceLookup.setArtifactId(referenceLookup.getArtifactId());
            artifactReferenceLookup.setGroupId(referenceLookup.getGroupId());
            artifactReferenceLookup.setName(referenceLookup.getParsedSchema().referenceName());
            artifactReferenceLookup.setVersion(referenceLookup.getVersion());
            artifactReferences.add(artifactReferenceLookup);
        });
        return artifactReferences;
    }

    private SchemaLookupResult<S> resolveSchemaByArtifactCoordinatesCached(ArtifactCoordinates artifactCoordinates) {
        return this.schemaCache.getByArtifactCoordinates(artifactCoordinates, artifactCoordinatesKey -> this.resolveByCoordinates(artifactCoordinatesKey.getGroupId(), artifactCoordinatesKey.getArtifactId(), artifactCoordinatesKey.getVersion()));
    }

    private SchemaLookupResult<S> resolveSchemaByArtifactReferenceCached(ArtifactReference artifactReference) {
        if (artifactReference.getGlobalId() != null) {
            return this.schemaCache.getByGlobalId(artifactReference.getGlobalId(), this::resolveSchemaByGlobalId);
        }
        if (artifactReference.getContentId() != null) {
            return this.schemaCache.getByContentId(artifactReference.getContentId(), this::resolveSchemaByContentId);
        }
        return this.schemaCache.getByArtifactCoordinates(ArtifactCoordinates.fromArtifactReference(artifactReference), artifactReferenceKey -> this.resolveByCoordinates(artifactReferenceKey.getGroupId(), artifactReferenceKey.getArtifactId(), artifactReferenceKey.getVersion()));
    }

    private SchemaLookupResult<S> resolveByCoordinates(String groupId, String artifactId, String version) {
        Long gid;
        ArtifactMetaData metadata;
        SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
        if (version == null) {
            metadata = this.client.getArtifactMetaData(groupId, artifactId);
            this.loadFromArtifactMetaData(metadata, result);
            gid = metadata.getGlobalId();
        } else {
            metadata = this.client.getArtifactVersionMetaData(groupId, artifactId, version);
            this.loadFromArtifactMetaData((VersionMetaData)metadata, result);
            gid = metadata.getGlobalId();
        }
        InputStream rawSchema = this.client.getContentByGlobalId(gid.longValue());
        List artifactReferences = this.client.getArtifactReferencesByGlobalId(gid.longValue());
        Map resolvedReferences = this.resolveReferences(artifactReferences);
        byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
        Object parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
        result.parsedSchema(new ParsedSchemaImpl().setParsedSchema(parsed).setRawSchema(schema));
        return result.build();
    }
}

