/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractKafkaSerDe;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.data.KafkaSerdeMetadata;
import io.apicurio.registry.serde.data.KafkaSerdeRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public abstract class AbstractKafkaSerializer<T, U>
extends AbstractKafkaSerDe<T, U>
implements Serializer<U> {
    public AbstractKafkaSerializer() {
    }

    public AbstractKafkaSerializer(RegistryClient client) {
        super(client);
    }

    public AbstractKafkaSerializer(SchemaResolver<T, U> schemaResolver) {
        super(schemaResolver);
    }

    public AbstractKafkaSerializer(RegistryClient client, ArtifactReferenceResolverStrategy<T, U> artifactResolverStrategy, SchemaResolver<T, U> schemaResolver) {
        super(client, schemaResolver);
        this.getSchemaResolver().setArtifactResolverStrategy(artifactResolverStrategy);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(new BaseKafkaSerDeConfig(configs), isKey);
    }

    protected abstract void serializeData(ParsedSchema<T> var1, U var2, OutputStream var3) throws IOException;

    protected abstract void serializeData(Headers var1, ParsedSchema<T> var2, U var3, OutputStream var4) throws IOException;

    public byte[] serialize(String topic, U data) {
        return this.serialize(topic, null, data);
    }

    public byte[] serialize(String topic, Headers headers, U data) {
        if (data == null) {
            return null;
        }
        try {
            KafkaSerdeMetadata resolverMetadata = new KafkaSerdeMetadata(topic, this.isKey(), headers);
            SchemaLookupResult schema = this.getSchemaResolver().resolveSchema(new KafkaSerdeRecord<U>(resolverMetadata, data));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (this.headersHandler != null && headers != null) {
                this.headersHandler.writeHeaders(headers, schema.toArtifactReference());
                this.serializeData(headers, schema.getParsedSchema(), data, out);
            } else {
                out.write(0);
                this.getIdHandler().writeId(schema.toArtifactReference(), out);
                this.serializeData(schema.getParsedSchema(), data, out);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void close() {
        try {
            this.schemaResolver.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

