/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.proxy;

import io.appium.java_client.proxy.Helpers;
import io.appium.java_client.proxy.MethodCallListener;
import io.appium.java_client.proxy.ProxyAwareListener;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class ElementAwareWebDriverListener
implements MethodCallListener,
ProxyAwareListener {
    private WebDriver parent;

    @Override
    public void attachProxyInstance(Object proxy) {
        if (proxy instanceof WebDriver) {
            this.parent = (WebDriver)proxy;
        }
    }

    @Override
    public Object call(Object obj, Method method, Object[] args, Callable<?> original) throws Throwable {
        Object result = original.call();
        if (result instanceof RemoteWebElement) {
            return this.wrapElement((RemoteWebElement)result);
        }
        if (result instanceof List) {
            return ((List)result).stream().map(item -> item instanceof RemoteWebElement ? this.wrapElement((RemoteWebElement)item) : item).collect(Collectors.toList());
        }
        return result;
    }

    private RemoteWebElement wrapElement(RemoteWebElement original) {
        RemoteWebElement proxy = Helpers.createProxy(RemoteWebElement.class, new Object[0], new Class[0], Collections.singletonList(this), (ElementMatcher<MethodDescription>)ElementMatchers.not((ElementMatcher)ElementMatchers.namedOneOf((String[])Helpers.OBJECT_METHOD_NAMES.toArray(new String[0])).or((ElementMatcher)ElementMatchers.named((String)"setId").or((ElementMatcher)ElementMatchers.named((String)"setParent")))));
        proxy.setId(original.getId());
        proxy.setParent((RemoteWebDriver)this.parent);
        return proxy;
    }
}

