/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.MissingParameterException;
import io.appium.java_client.PerformsActions;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;

public class MultiTouchAction
implements PerformsActions<MultiTouchAction> {
    private ImmutableList.Builder<TouchAction> actions;
    private PerformsTouchActions performsTouchActions;

    public MultiTouchAction(PerformsTouchActions performsTouchActions) {
        this.performsTouchActions = performsTouchActions;
        this.actions = ImmutableList.builder();
    }

    public MultiTouchAction add(TouchAction action) {
        this.actions.add((Object)action);
        return this;
    }

    @Override
    public MultiTouchAction perform() {
        int size = this.actions.build().size();
        if (size > 1) {
            this.performsTouchActions.performMultiTouchAction(this);
        } else if (size == 1) {
            this.performsTouchActions.performTouchAction((TouchAction)this.actions.build().get(0));
        } else {
            throw new MissingParameterException("MultiTouch action must have at least one TouchAction added before it can be performed");
        }
        return this;
    }

    protected ImmutableMap<String, ImmutableList<Object>> getParameters() {
        ImmutableList.Builder listOfActionChains = ImmutableList.builder();
        ImmutableList touchActions = this.actions.build();
        touchActions.forEach(action -> listOfActionChains.add(action.getParameters().get((Object)"actions")));
        return ImmutableMap.of((Object)"actions", (Object)listOfActionChains.build());
    }

    protected MultiTouchAction clearActions() {
        this.actions = ImmutableList.builder();
        return this;
    }
}

