/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.CanRememberExtensionPresence;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.appmanagement.ApplicationState;
import io.appium.java_client.appmanagement.BaseActivateApplicationOptions;
import io.appium.java_client.appmanagement.BaseInstallApplicationOptions;
import io.appium.java_client.appmanagement.BaseOptions;
import io.appium.java_client.appmanagement.BaseRemoveApplicationOptions;
import io.appium.java_client.appmanagement.BaseTerminateApplicationOptions;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.UnsupportedCommandException;

public interface InteractsWithApps
extends ExecutesMethod,
CanRememberExtensionPresence {
    default public void installApp(String appPath) {
        this.installApp(appPath, null);
    }

    default public void installApp(String appPath, @Nullable BaseInstallApplicationOptions options) {
        String extName = "mobile: installApp";
        try {
            ImmutableMap args = ImmutableMap.builder().put((Object)"app", (Object)appPath).put((Object)"appPath", (Object)appPath).putAll(Optional.ofNullable(options).map(BaseOptions::build).orElseGet(Collections::emptyMap)).build();
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: installApp"), "mobile: installApp", (Map<String, Object>)args);
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            ImmutableMap args = ImmutableMap.builder().put((Object)"appPath", (Object)appPath).putAll((Map)Optional.ofNullable(options).map(opts -> ImmutableMap.of((Object)"options", opts.build())).orElseGet(ImmutableMap::of)).build();
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: installApp"), new AbstractMap.SimpleEntry<String, ImmutableMap>(MobileCommand.INSTALL_APP, args));
        }
    }

    default public boolean isAppInstalled(String bundleId) {
        String extName = "mobile: isAppInstalled";
        try {
            return (Boolean)Preconditions.checkNotNull(CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: isAppInstalled"), "mobile: isAppInstalled", (Map<String, Object>)ImmutableMap.of((Object)"bundleId", (Object)bundleId, (Object)"appId", (Object)bundleId)));
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            return (Boolean)Preconditions.checkNotNull(CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: isAppInstalled"), new AbstractMap.SimpleEntry<String, ImmutableMap>(MobileCommand.IS_APP_INSTALLED, ImmutableMap.of((Object)"bundleId", (Object)bundleId))));
        }
    }

    default public void runAppInBackground(Duration duration) {
        String extName = "mobile: backgroundApp";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: backgroundApp"), "mobile: backgroundApp", (Map<String, Object>)ImmutableMap.of((Object)"seconds", (Object)((double)duration.toMillis() / 1000.0)));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: backgroundApp"), new AbstractMap.SimpleEntry<String, ImmutableMap>(MobileCommand.RUN_APP_IN_BACKGROUND, ImmutableMap.of((Object)"seconds", (Object)((double)duration.toMillis() / 1000.0))));
        }
    }

    default public boolean removeApp(String bundleId) {
        return this.removeApp(bundleId, null);
    }

    default public boolean removeApp(String bundleId, @Nullable BaseRemoveApplicationOptions options) {
        String extName = "mobile: removeApp";
        try {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).put((Object)"appId", (Object)bundleId).putAll(Optional.ofNullable(options).map(BaseOptions::build).orElseGet(Collections::emptyMap)).build();
            return (Boolean)Preconditions.checkNotNull(CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: removeApp"), "mobile: removeApp", (Map<String, Object>)args));
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).putAll((Map)Optional.ofNullable(options).map(opts -> ImmutableMap.of((Object)"options", opts.build())).orElseGet(ImmutableMap::of)).build();
            return (Boolean)Preconditions.checkNotNull((Object)((Boolean)CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: removeApp"), new AbstractMap.SimpleEntry<String, ImmutableMap>(MobileCommand.REMOVE_APP, args))));
        }
    }

    default public void activateApp(String bundleId) {
        this.activateApp(bundleId, null);
    }

    default public void activateApp(String bundleId, @Nullable BaseActivateApplicationOptions options) {
        String extName = "mobile: activateApp";
        try {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).put((Object)"appId", (Object)bundleId).putAll(Optional.ofNullable(options).map(BaseOptions::build).orElseGet(Collections::emptyMap)).build();
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: activateApp"), "mobile: activateApp", (Map<String, Object>)args);
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).putAll((Map)Optional.ofNullable(options).map(opts -> ImmutableMap.of((Object)"options", opts.build())).orElseGet(ImmutableMap::of)).build();
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: activateApp"), new AbstractMap.SimpleEntry<String, ImmutableMap>(MobileCommand.ACTIVATE_APP, args));
        }
    }

    default public ApplicationState queryAppState(String bundleId) {
        String extName = "mobile: queryAppState";
        try {
            return ApplicationState.ofCode((Long)Preconditions.checkNotNull(CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: queryAppState"), "mobile: queryAppState", (Map<String, Object>)ImmutableMap.of((Object)"bundleId", (Object)bundleId, (Object)"appId", (Object)bundleId))));
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            return ApplicationState.ofCode((Long)Preconditions.checkNotNull(CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: queryAppState"), new AbstractMap.SimpleEntry<String, ImmutableMap>(MobileCommand.QUERY_APP_STATE, ImmutableMap.of((Object)"bundleId", (Object)bundleId)))));
        }
    }

    default public boolean terminateApp(String bundleId) {
        return this.terminateApp(bundleId, null);
    }

    default public boolean terminateApp(String bundleId, @Nullable BaseTerminateApplicationOptions options) {
        String extName = "mobile: terminateApp";
        try {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).put((Object)"appId", (Object)bundleId).putAll(Optional.ofNullable(options).map(BaseOptions::build).orElseGet(Collections::emptyMap)).build();
            return (Boolean)Preconditions.checkNotNull(CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: terminateApp"), "mobile: terminateApp", (Map<String, Object>)args));
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).putAll((Map)Optional.ofNullable(options).map(opts -> ImmutableMap.of((Object)"options", opts.build())).orElseGet(ImmutableMap::of)).build();
            return (Boolean)Preconditions.checkNotNull((Object)((Boolean)CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: terminateApp"), new AbstractMap.SimpleEntry<String, ImmutableMap>(MobileCommand.TERMINATE_APP, args))));
        }
    }
}

