/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.CanRememberExtensionPresence;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.android.AndroidMobileCommandHelper;
import io.appium.java_client.android.connection.ConnectionState;
import java.util.Map;
import org.openqa.selenium.UnsupportedCommandException;

public interface HasNetworkConnection
extends ExecutesMethod,
CanRememberExtensionPresence {
    default public ConnectionState setConnection(ConnectionState connection) {
        String extName = "mobile: setConnectivity";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: setConnectivity"), "mobile: setConnectivity", (Map<String, Object>)ImmutableMap.of((Object)"wifi", (Object)connection.isWiFiEnabled(), (Object)"data", (Object)connection.isDataEnabled(), (Object)"airplaneMode", (Object)connection.isAirplaneModeEnabled()));
            return this.getConnection();
        }
        catch (UnsupportedCommandException e) {
            return new ConnectionState((Long)Preconditions.checkNotNull(CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: setConnectivity"), AndroidMobileCommandHelper.setConnectionCommand(connection.getBitMask()))));
        }
    }

    default public ConnectionState getConnection() {
        String extName = "mobile: getConnectivity";
        try {
            Map result = (Map)Preconditions.checkNotNull(CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: getConnectivity"), "mobile: getConnectivity"));
            return new ConnectionState(((Boolean)result.get("wifi") != false ? 2L : 0L) | ((Boolean)result.get("data") != false ? 4L : 0L) | ((Boolean)result.get("airplaneMode") != false ? 1L : 0L));
        }
        catch (UnsupportedCommandException e) {
            return new ConnectionState((Long)Preconditions.checkNotNull(CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: getConnectivity"), AndroidMobileCommandHelper.getNetworkConnectionCommand())));
        }
    }
}

