/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.AppiumElementLocator;
import io.appium.java_client.pagefactory.WithTimeout;
import io.appium.java_client.pagefactory.bys.builder.AppiumByBuilder;
import io.appium.java_client.pagefactory.locator.CacheableElementLocatorFactory;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;

public class AppiumElementLocatorFactory
implements CacheableElementLocatorFactory {
    private final SearchContext searchContext;
    private final WeakReference<SearchContext> searchContextReference;
    private final Duration duration;
    private final AppiumByBuilder builder;

    public AppiumElementLocatorFactory(SearchContext searchContext, Duration duration, AppiumByBuilder builder) {
        this.searchContext = searchContext;
        this.searchContextReference = null;
        this.duration = duration;
        this.builder = builder;
    }

    AppiumElementLocatorFactory(WeakReference<SearchContext> searchContextReference, Duration duration, AppiumByBuilder builder) {
        this.searchContextReference = searchContextReference;
        this.searchContext = null;
        this.duration = duration;
        this.builder = builder;
    }

    @Override
    @Nullable
    public CacheableLocator createLocator(Field field) {
        return this.createLocator((AnnotatedElement)field);
    }

    @Override
    @Nullable
    public CacheableLocator createLocator(AnnotatedElement annotatedElement) {
        Duration customDuration;
        if (annotatedElement.isAnnotationPresent(WithTimeout.class)) {
            WithTimeout withTimeout = annotatedElement.getAnnotation(WithTimeout.class);
            customDuration = WithTimeout.DurationBuilder.build(withTimeout);
        } else {
            customDuration = this.duration;
        }
        this.builder.setAnnotated(annotatedElement);
        By byResult = this.builder.buildBy();
        return Optional.ofNullable(byResult).map(by -> this.searchContextReference != null ? new AppiumElementLocator(this.searchContextReference, (By)by, this.builder.isLookupCached(), customDuration) : new AppiumElementLocator(this.searchContext, (By)by, this.builder.isLookupCached(), customDuration)).orElse(null);
    }
}

